/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.util.net;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.net.util.SubnetUtils;
import org.springframework.data.hadoop.util.net.HostInfoDiscovery;
import org.springframework.util.StringUtils;

public class DefaultHostInfoDiscovery
implements HostInfoDiscovery {
    private String matchIpv4;
    private String matchInterface;
    private List<String> preferInterface = Arrays.asList("eth", "en");
    private boolean pointToPoint = false;
    private boolean loopback = false;

    @Override
    public HostInfoDiscovery.HostInfo getHostInfo() {
        List<NetworkInterface> interfaces;
        try {
            interfaces = this.getAllAvailableInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        interfaces = this.filterInterfaces(interfaces);
        interfaces = this.sortInterfaces(interfaces);
        for (NetworkInterface nic : interfaces) {
            List<InetAddress> addresses = new ArrayList<InetAddress>();
            for (InterfaceAddress interfaceAddress : nic.getInterfaceAddresses()) {
                addresses.add(interfaceAddress.getAddress());
            }
            if ((addresses = this.filterAddresses(addresses)).isEmpty()) continue;
            InetAddress address = addresses.get(0);
            return new HostInfoDiscovery.HostInfo(address.getHostAddress(), address.getHostName());
        }
        return null;
    }

    public void setMatchIpv4(String matchIpv4) {
        this.matchIpv4 = matchIpv4;
    }

    public void setMatchInterface(String matchInterface) {
        this.matchInterface = matchInterface;
    }

    public void setPreferInterface(List<String> preferInterface) {
        this.preferInterface = preferInterface;
    }

    public void setPointToPoint(boolean pointToPoint) {
        this.pointToPoint = pointToPoint;
    }

    public void setLoopback(boolean loopback) {
        this.loopback = loopback;
    }

    protected List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(5);
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            interfaces.add(e.nextElement());
        }
        return interfaces;
    }

    private List<InetAddress> filterAddresses(List<InetAddress> addresses) {
        ArrayList<InetAddress> filtered = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            boolean match;
            boolean bl = match = address.getAddress() != null && address.getAddress().length == 4;
            if (!this.loopback && address.isLoopbackAddress()) {
                match = false;
            }
            if (match && StringUtils.hasText((String)this.matchIpv4)) {
                match = this.matchIpv4(this.matchIpv4, address.getHostAddress());
            }
            if (!match) continue;
            filtered.add(address);
        }
        return filtered;
    }

    private boolean matchIpv4(String addressMatch, String address) {
        SubnetUtils subnetUtils = new SubnetUtils(addressMatch);
        SubnetUtils.SubnetInfo info = subnetUtils.getInfo();
        return info.isInRange(address);
    }

    private List<NetworkInterface> filterInterfaces(List<NetworkInterface> interfaces) {
        ArrayList<NetworkInterface> filtered = new ArrayList<NetworkInterface>();
        for (NetworkInterface nic : interfaces) {
            boolean match = false;
            try {
                match = this.pointToPoint && nic.isPointToPoint();
            }
            catch (SocketException e) {
                // empty catch block
            }
            try {
                match = !match && this.loopback && nic.isLoopback();
            }
            catch (SocketException e) {
                // empty catch block
            }
            if (!match && !StringUtils.hasText((String)this.matchInterface)) {
                match = true;
            } else if (StringUtils.hasText((String)this.matchInterface)) {
                match = nic.getName().matches(this.matchInterface);
            }
            if (!match) continue;
            filtered.add(nic);
        }
        return filtered;
    }

    private List<NetworkInterface> sortInterfaces(List<NetworkInterface> interfaces) {
        Collections.sort(interfaces, new NicIndexComparator());
        Collections.sort(interfaces, new NicPreferNameComparator());
        return interfaces;
    }

    public String toString() {
        return "DefaultHostInfoDiscovery [matchIpv4=" + this.matchIpv4 + ", matchInterface=" + this.matchInterface + ", preferInterface=" + this.preferInterface + ", pointToPoint=" + this.pointToPoint + ", loopback=" + this.loopback + "]";
    }

    private class NicPreferNameComparator
    implements Comparator<NetworkInterface> {
        private NicPreferNameComparator() {
        }

        @Override
        public int compare(NetworkInterface o1, NetworkInterface o2) {
            String o1name = o1.getName();
            String o2name = o2.getName();
            if (this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o1name) && this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o2name)) {
                return 0;
            }
            if (this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o1name) && !this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o2name)) {
                return -1;
            }
            if (!this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o1name) && this.startWithAny(DefaultHostInfoDiscovery.this.preferInterface, o2name)) {
                return 1;
            }
            return o1name.compareTo(o2name);
        }

        private boolean startWithAny(List<String> prefixes, String name) {
            for (String prefix : prefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private class NicIndexComparator
    implements Comparator<NetworkInterface> {
        private NicIndexComparator() {
        }

        @Override
        public int compare(NetworkInterface o1, NetworkInterface o2) {
            return Integer.compare(o1.getIndex(), o2.getIndex());
        }
    }
}

