/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.management.UnitOfWork;
import cascading.stats.CascadingStats;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.cascading.Runner;

public class CascadeRunner
implements InitializingBean,
DisposableBean,
Callable<CascadingStats> {
    private boolean waitToComplete = true;
    private boolean runAtStartup = false;
    private UnitOfWork<CascadingStats> uow;
    private Iterable<Callable<?>> preActions;
    private Iterable<Callable<?>> postActions;

    public void afterPropertiesSet() throws Exception {
        if (this.runAtStartup) {
            this.call();
        }
    }

    public void destroy() {
        if (this.uow != null) {
            this.uow.stop();
        }
    }

    @Override
    public CascadingStats call() throws Exception {
        this.invoke(this.preActions);
        CascadingStats stats = Runner.run(this.uow, this.waitToComplete);
        this.invoke(this.postActions);
        return stats;
    }

    public void setUnitOfWork(UnitOfWork<CascadingStats> uow) {
        this.uow = uow;
    }

    public void setRunAtStartup(boolean runAtStartup) {
        this.runAtStartup = runAtStartup;
    }

    public void setPreAction(Collection<Callable<?>> actions) {
        this.preActions = actions;
    }

    public void setPostAction(Collection<Callable<?>> actions) {
        this.postActions = actions;
    }

    private void invoke(Iterable<Callable<?>> actions) throws Exception {
        if (actions != null) {
            for (Callable<?> action : actions) {
                action.call();
            }
        }
    }
}

