/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.flow.hadoop.MapReduceFlow;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.data.hadoop.cascading.FlowFactoryBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class MapReduceFlowFactoryBean
extends FlowFactoryBean<MapReduceFlow>
implements BeanNameAware {
    private Configuration configuration;
    private Properties properties;
    private Job job;
    private String beanName;
    private boolean deleteSinkOnInit = false;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    MapReduceFlow createFlow() {
        Configuration c = this.configuration;
        if (this.job != null) {
            c = ConfigurationUtils.merge(this.configuration, this.job.getConfiguration());
        }
        Configuration conf = ConfigurationUtils.createFrom(c, this.properties);
        JobConf jobConf = new JobConf(conf);
        return new MapReduceFlow(this.beanName, jobConf, this.deleteSinkOnInit, false);
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setDeleteSinkOnInit(boolean deleteSinkOnInit) {
        this.deleteSinkOnInit = deleteSinkOnInit;
    }
}

