/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

class LinkedProperties
extends Properties {
    private final LinkedHashSet<Object> keys = new LinkedHashSet();

    LinkedProperties(String text) {
        try {
            this.load(new ByteArrayInputStream(text.getBytes("ISO-8859-1")));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to parse [" + text + "] into Properties", ex);
        }
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.keys);
    }

    @Override
    public Object put(Object key, Object value) {
        this.keys.add(key);
        return super.put(key, value);
    }

    @Override
    public Set<String> stringPropertyNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object e : this.keys) {
            if (!(e instanceof String) || !(this.get(e) instanceof String)) continue;
            set.add((String)e);
        }
        return set;
    }

    @Override
    public Set<Object> keySet() {
        return this.keys;
    }
}

