/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class FsShellPermissions {
    FsShellPermissions() {
    }

    static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    static void changePermissions(FileSystem fs, Configuration config, Op op, boolean recursive, String group, String ... uris) {
        Object[] argvs = new String[]{};
        if (recursive) {
            ObjectUtils.addObjectToArray((Object[])argvs, (Object)"-R");
        }
        argvs = FsShellPermissions.concatAll(argvs, {group}, uris);
        Object[] args = new Object[]{fs, op.getCmd(), argvs, 0, new FsShell(config)};
        Class cls = ClassUtils.resolveClassName((String)"org.apache.hadoop.fs.FsShellPermissions", (ClassLoader)config.getClass().getClassLoader());
        Method m = ReflectionUtils.findMethod((Class)cls, (String)"changePermissions", (Class[])new Class[]{FileSystem.class, String.class, String[].class, Integer.TYPE, FsShell.class});
        ReflectionUtils.makeAccessible((Method)m);
        ReflectionUtils.invokeMethod((Method)m, null, (Object[])args);
    }

    static enum Op {
        CHOWN("-chown"),
        CHMOD("-chmod"),
        CHGRP("-chgrp");

        private final String cmd;

        private Op(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

