/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class HbaseConfigurationFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<Configuration> {
    private boolean deleteConnection = true;
    private boolean stopProxy = true;
    private Configuration configuration;
    private Configuration hadoopConfig;
    private Properties properties;

    public void setDeleteConnection(boolean deleteConnection) {
        this.deleteConnection = deleteConnection;
    }

    public void setStopProxy(boolean stopProxy) {
        this.stopProxy = stopProxy;
    }

    public void setConfiguration(Configuration configuration) {
        this.hadoopConfig = configuration;
    }

    public void destroy() {
        if (this.deleteConnection) {
            HConnectionManager.deleteConnection((Configuration)this.getObject(), (boolean)this.stopProxy);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() {
        this.configuration = this.hadoopConfig != null ? HBaseConfiguration.create((Configuration)this.hadoopConfig) : HBaseConfiguration.create();
        ConfigurationUtils.addProperties(this.configuration, this.properties);
    }

    public Configuration getObject() {
        return this.configuration;
    }

    public Class<? extends Configuration> getObjectType() {
        return this.configuration != null ? this.configuration.getClass() : Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

