/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.mapreduce.ExecutionUtils;
import org.springframework.data.hadoop.mapreduce.HadoopCodeExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

abstract class JarExecutor
extends HadoopCodeExecutor<Object> {
    private File savedConfiguration;
    private String configName;

    JarExecutor() {
    }

    @Override
    protected ClassLoader createClassLoaderForJar(Resource jar, ClassLoader parentCL, Configuration cfg) {
        return new ClassLoader(ExecutionUtils.createParentLastClassLoader(jar, parentCL, cfg)){

            @Override
            public URL getResource(String name) {
                if (JarExecutor.this.savedConfiguration != null && JarExecutor.this.configName != null && JarExecutor.this.configName.equals(name)) {
                    try {
                        return JarExecutor.this.savedConfiguration.toURI().toURL();
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Cannot add custom configuration", ex);
                    }
                }
                return super.getResource(name);
            }
        };
    }

    @Override
    protected Object resolveTargetObject(Class<Object> type) {
        return null;
    }

    @Override
    protected Object invokeTargetObject(Configuration cfg, Object target, Class<Object> targetClass, String[] args) throws Exception {
        Method main = ReflectionUtils.findMethod(targetClass, (String)"main", (Class[])new Class[]{String[].class});
        return ReflectionUtils.invokeMethod((Method)main, null, (Object[])new Object[]{args});
    }

    @Override
    protected void preExecution(Configuration cfg) {
        this.configName = "Custom-cfg-for- " + this.jar + "-" + UUID.randomUUID();
        try {
            this.savedConfiguration = File.createTempFile("SHDP-jar-cfg-", null);
            cfg.writeXml((OutputStream)new FileOutputStream(this.savedConfiguration));
            this.defaultResources().add(this.configName);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot set custom configuration", ex);
        }
    }

    @Override
    protected void postExecution(Configuration cfg) {
        this.defaultResources().remove(this.configName);
        this.savedConfiguration.delete();
        this.savedConfiguration = null;
        this.configName = null;
    }

    private List<String> defaultResources() {
        Field f = ReflectionUtils.findField(Configuration.class, (String)"defaultResources");
        ReflectionUtils.makeAccessible((Field)f);
        return (List)ReflectionUtils.getField((Field)f, null);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.jar != null && this.jar.exists() ? 1 : 0) != 0, (String)("jar location [" + this.jar + "] not found"));
    }

    public void setMainClass(String className) {
        this.setTargetClassName(className);
    }
}

