/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.util.ReflectionUtils;

public abstract class JobUtils {
    static Field JOB_INFO = ReflectionUtils.findField(Job.class, (String)"info");

    public static RunningJob getRunningJob(Job job) {
        if (job == null) {
            return null;
        }
        return (RunningJob)ReflectionUtils.getField((Field)JOB_INFO, (Object)job);
    }

    public static JobID getJobId(Job job) {
        if (job == null) {
            return null;
        }
        return job.getJobID();
    }

    public static org.apache.hadoop.mapred.JobID getOldJobId(Job job) {
        JobID id = JobUtils.getJobId(job);
        if (id != null) {
            return org.apache.hadoop.mapred.JobID.downgrade((JobID)id);
        }
        return null;
    }

    public static JobConf getJobConf(Job job) {
        if (job == null) {
            return null;
        }
        Configuration configuration = job.getConfiguration();
        if (configuration instanceof JobConf) {
            return (JobConf)configuration;
        }
        return (JobConf)ConfigurationUtils.createFrom(configuration, null);
    }

    static {
        ReflectionUtils.makeAccessible((Field)JOB_INFO);
    }
}

