/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.hadoop.fs.HdfsResource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class HdfsResourceLoader
implements ResourcePatternResolver,
PriorityOrdered,
Closeable,
DisposableBean {
    private static final String PREFIX_DELIMITER = ":";
    private final FileSystem fs;
    private final PathMatcher pathMatcher = new AntPathMatcher();
    private final boolean internalFS;
    private volatile boolean useCodecs = true;
    private volatile CompressionCodecFactory codecsFactory;

    public HdfsResourceLoader(Configuration config) {
        this(config, null);
    }

    public HdfsResourceLoader(Configuration config, URI uri, String user) {
        Assert.notNull((Object)config, (String)"a valid configuration is required");
        this.internalFS = true;
        FileSystem tempFS = null;
        this.codecsFactory = new CompressionCodecFactory(config);
        try {
            if (uri == null) {
                uri = FileSystem.getDefaultUri((Configuration)config);
            }
            tempFS = StringUtils.hasText((String)user) ? FileSystem.get((URI)uri, (Configuration)config, (String)user) : FileSystem.get((URI)uri, (Configuration)config);
        }
        catch (Exception ex) {
            tempFS = null;
            throw new IllegalStateException("Cannot create filesystem", ex);
        }
        finally {
            this.fs = tempFS;
        }
    }

    public HdfsResourceLoader(Configuration config, URI uri) {
        this(config, uri, null);
    }

    public HdfsResourceLoader(FileSystem fs) {
        Assert.notNull((Object)fs, (String)"a non-null file-system required");
        this.fs = fs;
        this.internalFS = false;
        this.codecsFactory = new CompressionCodecFactory(fs.getConf());
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public ClassLoader getClassLoader() {
        return this.fs.getConf().getClassLoader();
    }

    public Resource getResource(String location) {
        return new HdfsResource(location, this.fs, this.codecs());
    }

    private CompressionCodecFactory codecs() {
        return this.useCodecs ? this.codecsFactory : null;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (this.pathMatcher.isPattern(HdfsResourceLoader.stripPrefix(locationPattern))) {
            return this.findPathMatchingResources(locationPattern);
        }
        return new Resource[]{this.getResource(locationPattern)};
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("~/")) {
            locationPattern = locationPattern.substring(2);
        }
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        if (rootDirPath.isEmpty()) {
            rootDirPath = ".";
        }
        Resource rootDirResource = this.getResource(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        result.addAll(this.doFindPathMatchingPathResources(rootDirResource, subPattern));
        return result.toArray(new Resource[result.size()]);
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(PREFIX_DELIMITER) + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && this.pathMatcher.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    private Set<Resource> doFindPathMatchingPathResources(Resource rootDirResource, String subPattern) throws IOException {
        Path rootDir = rootDirResource instanceof HdfsResource ? ((HdfsResource)rootDirResource).getPath() : new Path(rootDirResource.getURI().toString());
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        String pattern = subPattern;
        if (!pattern.startsWith("/")) {
            pattern = "/".concat(pattern);
        }
        this.doRetrieveMatchingResources(rootDir, pattern, results);
        return results;
    }

    private void doRetrieveMatchingResources(Path rootDir, String subPattern, Set<Resource> results) throws IOException {
        if (!this.fs.isFile(rootDir)) {
            FileStatus[] statuses = null;
            try {
                statuses = this.fs.listStatus(rootDir);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (!ObjectUtils.isEmpty(statuses)) {
                String root = rootDir.toUri().getPath();
                for (FileStatus fileStatus : statuses) {
                    Path p = fileStatus.getPath();
                    String location = p.toUri().getPath();
                    if (location.startsWith(root)) {
                        location = location.substring(root.length());
                    }
                    if (fileStatus.isDir() && this.pathMatcher.matchStart(subPattern, location)) {
                        this.doRetrieveMatchingResources(p, subPattern, results);
                        continue;
                    }
                    if (!this.pathMatcher.match(subPattern, location)) continue;
                    results.add((Resource)new HdfsResource(p, this.fs, this.codecs()));
                }
            }
        } else if (this.pathMatcher.match(subPattern, HdfsResourceLoader.stripPrefix(rootDir.toUri().getPath()))) {
            results.add((Resource)new HdfsResource(rootDir, this.fs, this.codecs()));
        }
    }

    private static String stripPrefix(String path) {
        int index = path.indexOf(PREFIX_DELIMITER);
        return index > -1 ? path.substring(index + 1) : path;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void destroy() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null && this.internalFS) {
            try {
                this.fs.close();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setUseCodecs(boolean useCodecs) {
        this.useCodecs = useCodecs;
    }
}

