/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.streaming.StreamJob;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.data.hadoop.mapreduce.JobGenericOptions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class StreamJobFactoryBean
extends JobGenericOptions
implements InitializingBean,
FactoryBean<Job>,
BeanNameAware {
    private Job job;
    private String name;
    private String output;
    private String mapper;
    private String reducer;
    private String combiner;
    private String inputFormat;
    private String outputFormat;
    private String partitioner;
    private Integer numReduceTasks;
    private String[] input;
    private Configuration configuration;
    private Properties properties;
    private Properties cmdEnv;

    public void setBeanName(String name) {
        this.name = name;
    }

    public Job getObject() throws Exception {
        return this.job;
    }

    public Class<?> getObjectType() {
        return this.job != null ? this.job.getClass() : Job.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])this.input) ? 1 : 0) != 0, (String)"at least one input required");
        Assert.hasText((String)this.output, (String)"the output is required");
        final Configuration cfg = ConfigurationUtils.createFrom(this.configuration, this.properties);
        this.buildGenericOptions(cfg);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        StreamJobFactoryBean.addArgument(this.output, "-output", args);
        StreamJobFactoryBean.addArgument(this.mapper, "-mapper", args);
        StreamJobFactoryBean.addArgument(this.reducer, "-reducer", args);
        StreamJobFactoryBean.addArgument(this.combiner, "-combiner", args);
        StreamJobFactoryBean.addArgument(this.partitioner, "-partitioner", args);
        StreamJobFactoryBean.addArgument(this.inputFormat, "-inputformat", args);
        StreamJobFactoryBean.addArgument(this.outputFormat, "-outputformat", args);
        if (this.numReduceTasks != null) {
            StreamJobFactoryBean.addArgument(this.numReduceTasks.toString(), "-numReduceTasks", args);
        }
        final ArrayList<String> argsList = new ArrayList<String>(args.size() * 2 + 16);
        for (Map.Entry entry : args.entrySet()) {
            argsList.add((String)entry.getKey());
            argsList.add((String)entry.getValue());
        }
        if (this.cmdEnv != null) {
            Enumeration<?> props = this.cmdEnv.propertyNames();
            while (props.hasMoreElements()) {
                String key = props.nextElement().toString();
                argsList.add("-cmdenv");
                argsList.add(key + "=" + this.cmdEnv.getProperty(key));
            }
        }
        StreamJobFactoryBean.addArgument(this.input, "-input", argsList);
        if (StringUtils.hasText((String)this.user)) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    StreamJobFactoryBean.this.job = new Job(StreamJobFactoryBean.this.createStreamJob(cfg, argsList.toArray(new String[argsList.size()])));
                    return null;
                }
            });
        } else {
            this.job = new Job(this.createStreamJob(cfg, argsList.toArray(new String[argsList.size()])));
        }
        this.job.setJobName(this.name);
    }

    private Configuration createStreamJob(Configuration cfg, String[] args) {
        StreamJob job = new StreamJob();
        job.setConf(cfg);
        Field argv = ReflectionUtils.findField(job.getClass(), (String)"argv_");
        ReflectionUtils.makeAccessible((Field)argv);
        ReflectionUtils.setField((Field)argv, (Object)job, (Object)args);
        StreamJobFactoryBean.invokeMethod(job, "init");
        StreamJobFactoryBean.invokeMethod(job, "preProcessArgs");
        StreamJobFactoryBean.invokeMethod(job, "parseArgv");
        StreamJobFactoryBean.invokeMethod(job, "postProcessArgs");
        StreamJobFactoryBean.invokeMethod(job, "setJobConf");
        Field jobConf = ReflectionUtils.findField(job.getClass(), (String)"jobConf_");
        ReflectionUtils.makeAccessible((Field)jobConf);
        return (Configuration)ReflectionUtils.getField((Field)jobConf, (Object)job);
    }

    private static void invokeMethod(Object target, String methodName) {
        Method m = ReflectionUtils.findMethod(target.getClass(), (String)methodName);
        ReflectionUtils.makeAccessible((Method)m);
        ReflectionUtils.invokeMethod((Method)m, (Object)target);
    }

    private static void addArgument(String arg, String name, Map<String, String> args) {
        if (StringUtils.hasText((String)arg)) {
            args.put(name, arg.trim());
        }
    }

    static void addArgument(String[] args, String name, List<String> list) {
        if (!ObjectUtils.isEmpty((Object[])args)) {
            for (String string : args) {
                list.add(name);
                list.add(string.trim());
            }
        }
    }

    public void setInputPath(String ... input) {
        this.input = input;
    }

    public void setOutputPath(String output) {
        this.output = output;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setReducer(String reducer) {
        this.reducer = reducer;
    }

    public void setCombiner(String combiner) {
        this.combiner = combiner;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setPartitioner(String partitioner) {
        this.partitioner = partitioner;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCmdEnv(Properties cmdEnv) {
        this.cmdEnv = cmdEnv;
    }

    public void setNumberReducers(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

