/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.DtoInstantiatingConverter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

@FunctionalInterface
interface JdbcQueryExecution<T> {
    @Nullable
    public T execute(String var1, SqlParameterSource var2);

    public static class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;
        private final Lazy<Converter<Object, Object>> converter;

        ResultProcessingConverter(ResultProcessor processor, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext, EntityInstantiators instantiators) {
            this.processor = processor;
            this.converter = Lazy.of(() -> new DtoInstantiatingConverter(processor.getReturnedType().getReturnedType(), mappingContext, instantiators));
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType()) || returnedType.getReturnedType().isInstance(source)) {
                return source;
            }
            return this.processor.processResult(source, (Converter)this.converter.get());
        }
    }
}

