/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class JdbcSimpleTypes {
    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;
    private static final Set<Class<?>> JDBC_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private JdbcSimpleTypes() {
    }

    static {
        HashSet<Class<UUID>> classes = new HashSet<Class<UUID>>();
        classes.add(Long.class);
        classes.add(String.class);
        classes.add(BigInteger.class);
        classes.add(BigDecimal.class);
        classes.add(UUID.class);
        AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);
        HashSet<Class> simpleTypes = new HashSet<Class>();
        simpleTypes.add(BigDecimal.class);
        simpleTypes.add(BigInteger.class);
        simpleTypes.add(Array.class);
        simpleTypes.add(Clob.class);
        simpleTypes.add(Blob.class);
        simpleTypes.add(Date.class);
        simpleTypes.add(NClob.class);
        simpleTypes.add(Ref.class);
        simpleTypes.add(RowId.class);
        simpleTypes.add(Struct.class);
        simpleTypes.add(Time.class);
        simpleTypes.add(Timestamp.class);
        simpleTypes.add(UUID.class);
        simpleTypes.add(JdbcValue.class);
        JDBC_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(JDBC_SIMPLE_TYPES, true);
    }
}

