/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.data.relational.core.query.Query;
import org.springframework.util.Assert;

public class ScrollDelegate {
    public static <T> Window<T> scroll(Query query, Function<Query, List<T>> queryFunction, ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        int limit = query.getLimit();
        if (limit > 0 && limit != Integer.MAX_VALUE) {
            query = query.limit(limit + 1);
        }
        List<T> result = queryFunction.apply(query);
        if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition offset = (OffsetScrollPosition)scrollPosition;
            return ScrollDelegate.createWindow(result, limit, offset.positionFunction());
        }
        throw new UnsupportedOperationException("ScrollPosition " + scrollPosition + " not supported");
    }

    private static <T> Window<T> createWindow(List<T> result, int limit, IntFunction<? extends ScrollPosition> positionFunction) {
        return Window.from(ScrollDelegate.getFirst(limit, result), positionFunction, (boolean)ScrollDelegate.hasMoreElements(result, limit));
    }

    private static boolean hasMoreElements(List<?> result, int limit) {
        return !result.isEmpty() && result.size() > limit;
    }

    public static <T> List<T> getFirst(int count, List<T> list) {
        if (count > 0 && list.size() > count) {
            return list.subList(0, count);
        }
        return list;
    }
}

