/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull((Object)((Object)method));
        Assert.notNull((Object)em);
        this.method = method;
        this.em = em;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        return execution.execute(this, values);
    }

    protected JpaQueryExecution getExecution() {
        switch (this.method.getType()) {
            case COLLECTION: {
                return new JpaQueryExecution.CollectionExecution();
            }
            case PAGING: {
                return new JpaQueryExecution.PagedExecution(this.method.getParameters());
            }
            case MODIFYING: {
                return this.method.getClearAutomatically() ? new JpaQueryExecution.ModifyingExecution(this.method, this.em) : new JpaQueryExecution.ModifyingExecution(this.method, null);
            }
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected ParameterBinder createBinder(Object[] values) {
        return new ParameterBinder(this.getQueryMethod().getParameters(), values);
    }

    protected abstract Query createQuery(Object[] var1);

    protected abstract Query createCountQuery(Object[] var1);
}

