/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaQueryMethod
extends QueryMethod {
    private final QueryExtractor extractor;
    private final Method method;

    public JpaQueryMethod(Method method, RepositoryMetadata metadata, QueryExtractor extractor) {
        super(method, metadata);
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        this.method = method;
        this.extractor = extractor;
        Assert.isTrue((!this.isModifyingQuery() || !this.getParameters().hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
    }

    public boolean isModifyingQuery() {
        return null != this.method.getAnnotation(Modifying.class);
    }

    List<QueryHint> getHints() {
        ArrayList<QueryHint> result = new ArrayList<QueryHint>();
        QueryHints hints = (QueryHints)AnnotationUtils.getAnnotation((Method)this.method, QueryHints.class);
        if (hints != null) {
            result.addAll(Arrays.asList(hints.value()));
        }
        return result;
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation());
        return StringUtils.hasText((String)query) ? query : null;
    }

    String getCountQuery() {
        String countQuery = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"countQuery");
        return StringUtils.hasText((String)countQuery) ? countQuery : null;
    }

    boolean getClearAutomatically() {
        return (Boolean)AnnotationUtils.getValue((Annotation)this.method.getAnnotation(Modifying.class), (String)"clearAutomatically");
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }
}

