/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.data.jpa.repository.config.SimpleJpaRepositoryConfiguration;
import org.springframework.data.repository.config.AbstractRepositoryConfigDefinitionParser;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaRepositoryConfigDefinitionParser
extends AbstractRepositoryConfigDefinitionParser<SimpleJpaRepositoryConfiguration, SimpleJpaRepositoryConfiguration.JpaRepositoryConfiguration> {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final Class<?> PET_POST_PROCESSOR = PersistenceExceptionTranslationPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";

    JpaRepositoryConfigDefinitionParser() {
    }

    protected SimpleJpaRepositoryConfiguration getGlobalRepositoryConfigInformation(Element element) {
        return new SimpleJpaRepositoryConfiguration(element);
    }

    protected void postProcessBeanDefinition(SimpleJpaRepositoryConfiguration.JpaRepositoryConfiguration ctx, BeanDefinitionBuilder builder, BeanDefinitionRegistry registry, Object beanSource) {
        String transactionManagerRef = StringUtils.hasText((String)ctx.getTransactionManagerRef()) ? ctx.getTransactionManagerRef() : DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef);
        String entityManagerRef = ctx.getEntityManagerFactoryRef();
        if (StringUtils.hasText((String)entityManagerRef)) {
            builder.addPropertyValue("entityManager", (Object)this.getEntityManagerBeanDefinitionFor(entityManagerRef, beanSource));
        }
    }

    private BeanDefinition getEntityManagerBeanDefinitionFor(String entityManagerFactoryBeanName, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(entityManagerFactoryBeanName);
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    protected void registerBeansForRoot(BeanDefinitionRegistry registry, Object source) {
        AbstractBeanDefinition definition;
        super.registerBeansForRoot(registry, source);
        if (!JpaRepositoryConfigDefinitionParser.hasBean(PET_POST_PROCESSOR, (BeanDefinitionRegistry)registry)) {
            definition = BeanDefinitionBuilder.rootBeanDefinition(PET_POST_PROCESSOR).getBeanDefinition();
            JpaRepositoryConfigDefinitionParser.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)definition, (Object)source);
        }
        if (!JpaRepositoryConfigDefinitionParser.hasBean(PAB_POST_PROCESSOR, (BeanDefinitionRegistry)registry)) {
            definition = BeanDefinitionBuilder.rootBeanDefinition(PAB_POST_PROCESSOR).getBeanDefinition();
            JpaRepositoryConfigDefinitionParser.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)definition, (Object)source);
        }
    }
}

