/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.QueryExtractor;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.LockModeRepositoryPostProcessor;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.data.jpa.repository.support.QueryDslJpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;

public class JpaRepositoryFactory
extends RepositoryFactorySupport {
    private final EntityManager entityManager;
    private final QueryExtractor extractor;
    private final LockModeRepositoryPostProcessor lockModePostProcessor;

    public JpaRepositoryFactory(EntityManager entityManager) {
        Assert.notNull((Object)entityManager);
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager(entityManager);
        this.lockModePostProcessor = LockModeRepositoryPostProcessor.INSTANCE;
        this.addRepositoryProxyPostProcessor(this.lockModePostProcessor);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        return this.getTargetRepository(metadata, this.entityManager);
    }

    protected <T, ID extends Serializable> JpaRepository<?, ?> getTargetRepository(RepositoryMetadata metadata, EntityManager entityManager) {
        Class repositoryInterface = metadata.getRepositoryInterface();
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleJpaRepository repo = this.isQueryDslExecutor(repositoryInterface) ? new QueryDslJpaRepository(entityInformation, entityManager) : new SimpleJpaRepository(entityInformation, entityManager);
        repo.setLockMetadataProvider(this.lockModePostProcessor.getLockMetadataProvider());
        return repo;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
            return QueryDslJpaRepository.class;
        }
        return SimpleJpaRepository.class;
    }

    private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return JpaQueryLookupStrategy.create(this.entityManager, key, this.extractor);
    }

    public <T, ID extends Serializable> JpaEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return JpaEntityInformationSupport.getMetadata(domainClass, this.entityManager);
    }
}

