/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

enum CrudMethodMetadataPostProcessor implements RepositoryProxyPostProcessor
{
    INSTANCE;


    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)ExposeInvocationInterceptor.INSTANCE);
        factory.addAdvice((Advice)CrudMethodMetadataPopulatingMethodIntercceptor.INSTANCE);
    }

    public CrudMethodMetadata getLockMetadataProvider() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource((TargetSource)new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy();
    }

    private static class ThreadBoundTargetSource
    extends AbstractLazyCreationTargetSource {
        private ThreadBoundTargetSource() {
        }

        protected Object createObject() throws Exception {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
        }
    }

    private static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        private final LockModeType lockModeType;
        private final Map<String, Object> queryHints;

        public DefaultCrudMethodMetadata(Method method) {
            Assert.notNull((Object)method, (String)"Method must not be null!");
            this.lockModeType = DefaultCrudMethodMetadata.findLockModeType(method);
            this.queryHints = DefaultCrudMethodMetadata.findQueryHints(method);
        }

        private static final LockModeType findLockModeType(Method method) {
            Lock annotation = (Lock)AnnotationUtils.findAnnotation((Method)method, Lock.class);
            return annotation == null ? null : (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
        }

        private static final Map<String, Object> findQueryHints(Method method) {
            QueryHint queryHintAnnotation;
            HashMap<String, String> queryHints = new HashMap<String, String>();
            QueryHints queryHintsAnnotation = (QueryHints)AnnotationUtils.findAnnotation((Method)method, QueryHints.class);
            if (queryHintsAnnotation != null) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.put(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = (QueryHint)AnnotationUtils.findAnnotation((Method)method, QueryHint.class)) != null) {
                queryHints.put(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return Collections.unmodifiableMap(queryHints);
        }

        @Override
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public Map<String, Object> getQueryHints() {
            return this.queryHints;
        }
    }

    static enum CrudMethodMetadataPopulatingMethodIntercceptor implements MethodInterceptor
    {
        INSTANCE;

        private final ConcurrentMap<Method, CrudMethodMetadata> metadataCache = new ConcurrentHashMap<Method, CrudMethodMetadata>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            CrudMethodMetadata tmp;
            Method method = invocation.getMethod();
            Object metadata = TransactionSynchronizationManager.getResource((Object)method);
            if (metadata != null) {
                return invocation.proceed();
            }
            CrudMethodMetadata methodMetadata = (CrudMethodMetadata)this.metadataCache.get(method);
            if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(method, methodMetadata = new DefaultCrudMethodMetadata(method))) != null) {
                metadata = tmp;
            }
            TransactionSynchronizationManager.bindResource((Object)method, (Object)methodMetadata);
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)method);
            }
        }
    }
}

