/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final PartTree tree;
    private final JpaParameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;
    private final EntityManager em;

    PartTreeJpaQuery(JpaQueryMethod method, EntityManager em, PersistenceProvider persistenceProvider) {
        super(method, em);
        this.em = em;
        Class domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), domainClass);
        this.parameters = method.getParameters();
        boolean recreationRequired = this.parameters.hasDynamicProjection() || this.parameters.potentiallySortsDynamically();
        this.countQuery = new CountQueryPreparer(persistenceProvider, recreationRequired);
        this.query = this.tree.isCountProjection() ? this.countQuery : new QueryPreparer(persistenceProvider, recreationRequired);
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    public TypedQuery<Long> doCreateCountQuery(Object[] values) {
        return (TypedQuery)this.countQuery.createQuery(values);
    }

    @Override
    protected JpaQueryExecution getExecution() {
        if (this.tree.isDelete()) {
            return new JpaQueryExecution.DeleteExecution(this.em);
        }
        if (this.tree.isExistsProjection().booleanValue()) {
            return new JpaQueryExecution.ExistsExecution();
        }
        return super.getExecution();
    }

    private class CountQueryPreparer
    extends QueryPreparer {
        CountQueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            super(persistenceProvider, recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator(PersistenceProvider persistenceProvider, Optional<ParametersParameterAccessor> accessor) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor.map(it -> new ParameterMetadataProvider(builder, (ParametersParameterAccessor)it, persistenceProvider)).orElseGet(() -> new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, persistenceProvider));
            return new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.getQueryMethod().getResultProcessor().getReturnedType(), builder, provider);
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, Object[] values) {
            return binder.bind(query, values);
        }
    }

    private class QueryPreparer {
        private final CriteriaQuery<?> cachedCriteriaQuery;
        private final ParameterBinder cachedParameterBinder;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;
        private final PersistenceProvider persistenceProvider;

        QueryPreparer(PersistenceProvider persistenceProvider, boolean recreateQueries) {
            this.persistenceProvider = persistenceProvider;
            JpaQueryCreator creator = this.createCreator(persistenceProvider, Optional.empty());
            if (recreateQueries) {
                this.cachedCriteriaQuery = null;
                this.expressions = null;
                this.cachedParameterBinder = null;
            } else {
                this.cachedCriteriaQuery = (CriteriaQuery)creator.createQuery();
                this.expressions = creator.getParameterExpressions();
                this.cachedParameterBinder = this.getBinder(this.expressions);
            }
        }

        public Query createQuery(Object[] values) {
            CriteriaQuery criteriaQuery = this.cachedCriteriaQuery;
            ParameterBinder parameterBinder = this.cachedParameterBinder;
            ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values);
            if (this.cachedCriteriaQuery == null || accessor.hasBindableNullValue()) {
                JpaQueryCreator creator = this.createCreator(this.persistenceProvider, Optional.of(accessor));
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(values));
                List<ParameterMetadataProvider.ParameterMetadata<?>> expressions = creator.getParameterExpressions();
                parameterBinder = this.getBinder(expressions);
            }
            TypedQuery<?> jpaQuery = this.createQuery(criteriaQuery);
            return this.restrictMaxResultsIfNecessary(this.invokeBinding(parameterBinder, jpaQuery, values));
        }

        private Query restrictMaxResultsIfNecessary(Query query) {
            if (PartTreeJpaQuery.this.tree.isLimiting()) {
                if (query.getMaxResults() != Integer.MAX_VALUE && query.getMaxResults() > PartTreeJpaQuery.this.tree.getMaxResults() && query.getFirstResult() > 0) {
                    query.setFirstResult(query.getFirstResult() - (query.getMaxResults() - PartTreeJpaQuery.this.tree.getMaxResults()));
                }
                query.setMaxResults(PartTreeJpaQuery.this.tree.getMaxResults().intValue());
            }
            if (PartTreeJpaQuery.this.tree.isExistsProjection().booleanValue()) {
                query.setMaxResults(1);
            }
            return query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TypedQuery<?> createQuery(CriteriaQuery<?> criteriaQuery) {
            if (this.cachedCriteriaQuery != null) {
                CriteriaQuery<?> criteriaQuery2 = this.cachedCriteriaQuery;
                synchronized (criteriaQuery2) {
                    return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
                }
            }
            return PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
        }

        protected JpaQueryCreator createCreator(PersistenceProvider persistenceProvider, Optional<ParametersParameterAccessor> accessor) {
            EntityManager entityManager = PartTreeJpaQuery.this.getEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            ParameterMetadataProvider provider = accessor.map(it -> new ParameterMetadataProvider(builder, (ParametersParameterAccessor)it, persistenceProvider)).orElseGet(() -> new ParameterMetadataProvider(builder, PartTreeJpaQuery.this.parameters, persistenceProvider));
            ResultProcessor processor = PartTreeJpaQuery.this.getQueryMethod().getResultProcessor();
            ReturnedType returnedType = accessor.map(arg_0 -> ((ResultProcessor)processor).withDynamicProjection(arg_0)).orElse(processor).getReturnedType();
            return new JpaQueryCreator(PartTreeJpaQuery.this.tree, returnedType, builder, provider);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query, Object[] values) {
            return binder.bindAndPrepare((Query)query, values);
        }

        private ParameterBinder getBinder(List<ParameterMetadataProvider.ParameterMetadata<?>> expressions) {
            return ParameterBinderFactory.createCriteriaBinder(PartTreeJpaQuery.this.parameters, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? new ParametersParameterAccessor((Parameters)PartTreeJpaQuery.this.parameters, values).getSort() : Sort.unsorted();
        }
    }
}

