/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import java.util.function.Function;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.util.Assert;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query, values) -> {};

    public void setParameter(Query var1, Object[] var2);

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private final Function<Object[], Object> valueExtractor;
        private final Parameter<?> parameter;
        private final TemporalType temporalType;
        private final boolean lenient;

        NamedOrIndexedQueryParameterSetter(Function<Object[], Object> valueExtractor, Parameter<?> parameter, TemporalType temporalType, boolean lenient) {
            Assert.notNull(valueExtractor, (String)"ValueExtractor must not be null!");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
            this.lenient = lenient;
        }

        @Override
        public void setParameter(Query query, Object[] values) {
            block12: {
                Object value = this.valueExtractor.apply(values);
                try {
                    if (this.temporalType != null) {
                        if (this.parameter instanceof ParameterExpression) {
                            query.setParameter(this.parameter, (Date)value, this.temporalType);
                        } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                            query.setParameter(this.parameter.getName(), (Date)value, this.temporalType);
                        } else {
                            query.setParameter(this.parameter.getPosition().intValue(), (Date)value, this.temporalType);
                        }
                    } else if (this.parameter instanceof ParameterExpression) {
                        query.setParameter(this.parameter, value);
                    } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                        query.setParameter(this.parameter.getName(), value);
                    } else {
                        query.setParameter(this.parameter.getPosition().intValue(), value);
                    }
                }
                catch (IllegalArgumentException o_O) {
                    if (this.lenient) break block12;
                    throw o_O;
                }
            }
        }
    }
}

