/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        this(method, em, method.getRequiredAnnotatedQuery(), evaluationContextProvider, parser);
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em, queryString, evaluationContextProvider, parser);
        this.validateQuery(this.getQuery().getQueryString(), String.format("Validation failed for query for method %s!", new Object[]{method}));
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s!", new Object[]{method}));
        }
    }

    private void validateQuery(String query, String errorMessage) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        try (EntityManager validatingEm = null;){
            validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
    }
}

