/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.HqlLexer;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryTransformer;
import org.springframework.data.jpa.repository.query.JpaQueryParserSupport;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.lang.Nullable;

class HqlQueryParser
extends JpaQueryParserSupport {
    HqlQueryParser(String query) {
        super(query);
    }

    public static ParserRuleContext parseQuery(String query) {
        HqlLexer lexer = new HqlLexer((CharStream)CharStreams.fromString((String)query));
        HqlParser parser = new HqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        HqlQueryParser.configureParser(query, lexer, parser);
        return parser.start();
    }

    @Override
    protected ParserRuleContext parse(String query) {
        return HqlQueryParser.parseQuery(query);
    }

    @Override
    protected List<JpaQueryParsingToken> applySort(ParserRuleContext parsedQuery, Sort sort) {
        return (List)new HqlQueryTransformer(sort).visit((ParseTree)parsedQuery);
    }

    @Override
    protected List<JpaQueryParsingToken> doCreateCountQuery(ParserRuleContext parsedQuery, @Nullable String countProjection) {
        return (List)new HqlQueryTransformer(true, countProjection).visit((ParseTree)parsedQuery);
    }

    @Override
    protected String doFindAlias(ParserRuleContext parsedQuery) {
        HqlQueryTransformer transformVisitor = new HqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getAlias();
    }

    @Override
    protected List<JpaQueryParsingToken> doFindProjection(ParserRuleContext parsedQuery) {
        HqlQueryTransformer transformVisitor = new HqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getProjection();
    }

    @Override
    protected boolean doCheckForConstructor(ParserRuleContext parsedQuery) {
        HqlQueryTransformer transformVisitor = new HqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.hasConstructorExpression();
    }
}

