/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.EqlLexer;
import org.springframework.data.jpa.repository.query.EqlParser;
import org.springframework.data.jpa.repository.query.EqlQueryTransformer;
import org.springframework.data.jpa.repository.query.JpaQueryParserSupport;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.lang.Nullable;

class EqlQueryParser
extends JpaQueryParserSupport {
    EqlQueryParser(String query) {
        super(query);
    }

    public static ParserRuleContext parseQuery(String query) {
        EqlLexer lexer = new EqlLexer((CharStream)CharStreams.fromString((String)query));
        EqlParser parser = new EqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        EqlQueryParser.configureParser(query, lexer, parser);
        return parser.start();
    }

    @Override
    protected ParserRuleContext parse(String query) {
        return EqlQueryParser.parseQuery(query);
    }

    @Override
    protected List<JpaQueryParsingToken> applySort(ParserRuleContext parsedQuery, Sort sort) {
        return (List)new EqlQueryTransformer(sort).visit((ParseTree)parsedQuery);
    }

    @Override
    protected List<JpaQueryParsingToken> doCreateCountQuery(ParserRuleContext parsedQuery, @Nullable String countProjection) {
        return (List)new EqlQueryTransformer(true, countProjection).visit((ParseTree)parsedQuery);
    }

    @Override
    protected String doFindAlias(ParserRuleContext parsedQuery) {
        EqlQueryTransformer transformVisitor = new EqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getAlias();
    }

    @Override
    protected List<JpaQueryParsingToken> doFindProjection(ParserRuleContext parsedQuery) {
        EqlQueryTransformer transformVisitor = new EqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.getProjection();
    }

    @Override
    protected boolean doCheckForConstructor(ParserRuleContext parsedQuery) {
        EqlQueryTransformer transformVisitor = new EqlQueryTransformer();
        transformVisitor.visit((ParseTree)parsedQuery);
        return transformVisitor.hasConstructorExpression();
    }
}

