/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.util.ObjectUtils;

class JpaQueryTransformerSupport {
    private static final Pattern PUNCTUATION_PATTERN = Pattern.compile(".*((?![._])[\\p{Punct}|\\s])");
    private static final String UNSAFE_PROPERTY_REFERENCE = "Sort expression '%s' must only contain property references or aliases used in the select clause; If you really want to use something other than that for sorting, please use JpaSort.unsafe(\u2026)";
    private final Set<String> projectionAliases = new HashSet<String>();

    JpaQueryTransformerSupport() {
    }

    void registerAlias(String token) {
        this.projectionAliases.add(token);
    }

    void registerAlias(QueryToken token) {
        this.projectionAliases.add(token.value());
    }

    List<QueryToken> orderBy(@Nullable String primaryFromAlias, Sort sort) {
        ArrayList<QueryToken> tokens = new ArrayList<QueryToken>();
        sort.forEach(order -> {
            QueryUtils.checkSortExpression(order);
            StringBuilder builder = new StringBuilder();
            if (order.isIgnoreCase()) {
                builder.append(QueryTokens.TOKEN_LOWER_FUNC.value());
            }
            builder.append(this.generateOrderByArgument(primaryFromAlias, (Sort.Order)order));
            if (order.isIgnoreCase()) {
                builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            }
            builder.append(" ");
            builder.append(order.isDescending() ? QueryTokens.TOKEN_DESC : QueryTokens.TOKEN_ASC);
            if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
                builder.append(" NULLS FIRST");
            } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
                builder.append(" NULLS LAST");
            }
            if (!tokens.isEmpty()) {
                tokens.add(QueryTokens.TOKEN_COMMA);
            }
            tokens.add(QueryTokens.token(builder.toString()));
        });
        return tokens;
    }

    private String generateOrderByArgument(@Nullable String primaryFromAlias, Sort.Order order) {
        if (this.shouldPrefixWithAlias(order, primaryFromAlias)) {
            return primaryFromAlias + "." + order.getProperty();
        }
        return order.getProperty();
    }

    private boolean shouldPrefixWithAlias(Sort.Order order, @Nullable String primaryFromAlias) {
        if (ObjectUtils.isEmpty((Object)primaryFromAlias)) {
            return false;
        }
        if (order.getProperty().contains("(")) {
            return false;
        }
        if (order.getProperty().startsWith(primaryFromAlias + ".")) {
            return false;
        }
        if (this.projectionAliases.contains(order.getProperty())) {
            return false;
        }
        return !this.projectionAliases.stream().anyMatch(alias -> order.getProperty().startsWith(alias + "."));
    }
}

