/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Optional;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

class GeneratingIdAccessor
implements IdentifierAccessor {
    private final PersistentPropertyAccessor accessor;
    private final PersistentProperty<?> identifierProperty;
    private final IdentifierGenerator generator;

    public GeneratingIdAccessor(PersistentPropertyAccessor accessor, PersistentProperty<?> identifierProperty, IdentifierGenerator generator) {
        Assert.notNull((Object)accessor, (String)"PersistentPropertyAccessor must not be null!");
        Assert.notNull(identifierProperty, (String)"Identifier property must not be null!");
        Assert.notNull((Object)generator, (String)"IdentifierGenerator must not be null!");
        this.accessor = accessor;
        this.identifierProperty = identifierProperty;
        this.generator = generator;
    }

    public Optional<Object> getIdentifier() {
        return this.accessor.getProperty(this.identifierProperty);
    }

    public Object getOrGenerateIdentifier() {
        Optional<Object> existingIdentifier = this.getIdentifier();
        if (existingIdentifier.isPresent()) {
            return existingIdentifier.get();
        }
        Object generatedIdentifier = this.generator.generateIdentifierOfType(this.identifierProperty.getTypeInformation());
        this.accessor.setProperty(this.identifierProperty, Optional.ofNullable(generatedIdentifier));
        return generatedIdentifier;
    }
}

