/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.keyvalue.repository.config.QueryCreatorType;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public abstract class KeyValueRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected static final String MAPPING_CONTEXT_BEAN_NAME = "keyValueMappingContext";
    protected static final String KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE = "keyValueTemplateRef";

    public String getRepositoryFactoryBeanClassName() {
        return KeyValueRepositoryFactoryBean.class.getName();
    }

    public String getModuleName() {
        return "KeyValue";
    }

    protected String getModulePrefix() {
        return "keyvalue";
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(KeyValueRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("keyValueOperations", attributes.getString(KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE));
        builder.addPropertyValue("queryCreator", KeyValueRepositoryConfigurationExtension.getQueryCreatorType(config));
        builder.addPropertyValue("queryType", KeyValueRepositoryConfigurationExtension.getQueryType(config));
        builder.addPropertyReference("mappingContext", MAPPING_CONTEXT_BEAN_NAME);
    }

    private static Class<?> getQueryCreatorType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map queryCreatorAnnotationAttributes = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorAnnotationAttributes == null) {
            return SpelQueryCreator.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorAnnotationAttributes);
        return queryCreatorAttributes.getClass("value");
    }

    private static Class<?> getQueryType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map queryCreatorAnnotationAttributes = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorAnnotationAttributes == null) {
            return KeyValuePartTreeQuery.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorAnnotationAttributes);
        return queryCreatorAttributes.getClass("repositoryQueryType");
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        AbstractBeanDefinition beanDefinition;
        super.registerBeansForRoot(registry, configurationSource);
        RootBeanDefinition mappingContextDefinition = new RootBeanDefinition(KeyValueMappingContext.class);
        mappingContextDefinition.setSource(configurationSource.getSource());
        KeyValueRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)mappingContextDefinition, (BeanDefinitionRegistry)registry, (String)MAPPING_CONTEXT_BEAN_NAME, (Object)configurationSource);
        Optional keyValueTemplateName = configurationSource.getAttribute(KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE);
        if (keyValueTemplateName.isPresent() && this.getDefaultKeyValueTemplateRef().equals(keyValueTemplateName.get()) && !registry.containsBeanDefinition((String)keyValueTemplateName.get()) && (beanDefinition = this.getDefaultKeyValueTemplateBeanDefinition(configurationSource)) != null) {
            KeyValueRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry, (String)((String)keyValueTemplateName.get()), (Object)configurationSource.getSource());
        }
    }

    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        return null;
    }

    protected abstract String getDefaultKeyValueTemplateRef();
}

