/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;

public class SimpleKeyValueRepository<T, ID extends Serializable>
implements KeyValueRepository<T, ID> {
    private final KeyValueOperations operations;
    private final EntityInformation<T, ID> entityInformation;

    public SimpleKeyValueRepository(EntityInformation<T, ID> metadata, KeyValueOperations operations) {
        Assert.notNull(metadata, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)operations, (String)"KeyValueOperations must not be null!");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public Iterable<T> findAll(Sort sort) {
        return this.operations.findAll(sort, this.entityInformation.getJavaType());
    }

    public Page<T> findAll(Pageable pageable) {
        if (pageable == null) {
            Iterable result = this.findAll();
            return new PageImpl((List)result, Pageable.unpaged(), (long)result.size());
        }
        Iterable content = this.operations.findInRange(pageable.getOffset(), pageable.getPageSize(), pageable.getSort(), this.entityInformation.getJavaType());
        return new PageImpl(IterableConverter.toList(content), pageable, this.operations.count(this.entityInformation.getJavaType()));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        if (this.entityInformation.isNew(entity)) {
            this.operations.insert(entity);
        } else {
            this.operations.update((Serializable)this.entityInformation.getId(entity).get(), entity);
        }
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        for (S entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public Optional<T> findOne(ID id) {
        return this.operations.findById((Serializable)id, this.entityInformation.getJavaType());
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public List<T> findAll() {
        return IterableConverter.toList(this.operations.findAll(this.entityInformation.getJavaType()));
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        ArrayList<T> result = new ArrayList<T>();
        for (Serializable id : ids) {
            Optional<T> candidate = this.findOne(id);
            if (!candidate.isPresent()) continue;
            result.add(candidate.get());
        }
        return result;
    }

    public long count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public void delete(ID id) {
        this.operations.delete((Serializable)id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        this.delete((T)((Serializable)this.entityInformation.getId(entity).orElseThrow(() -> new IllegalArgumentException("Cannot delete entity with 'null' id."))));
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.operations.delete(this.entityInformation.getJavaType());
    }
}

