/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.persistence.document;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.persistence.ChangeSetBacked;
import org.springframework.data.persistence.ChangeSetPersister;
import org.springframework.transaction.support.TransactionSynchronization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBackedTransactionSynchronization
implements TransactionSynchronization {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ChangeSetPersister<Object> changeSetPersister;
    private ChangeSetBacked entity;
    private int changeSetTxStatus = -1;

    public DocumentBackedTransactionSynchronization(ChangeSetPersister<Object> changeSetPersister, ChangeSetBacked entity) {
        this.changeSetPersister = changeSetPersister;
        this.entity = entity;
    }

    public void afterCommit() {
        this.log.debug((Object)("After Commit called for " + this.entity));
        this.changeSetPersister.persistState(this.entity, this.entity.getChangeSet());
        this.changeSetTxStatus = 0;
    }

    public void afterCompletion(int status) {
        this.log.debug((Object)("After Completion called with status = " + status));
        if (this.changeSetTxStatus == 0) {
            if (status == 0) {
                this.log.debug((Object)("ChangedSetBackedTransactionSynchronization completed successfully for " + this.entity));
            } else {
                this.log.error((Object)("ChangedSetBackedTransactionSynchronization failed for " + this.entity));
            }
        }
    }

    public void beforeCommit(boolean readOnly) {
    }

    public void beforeCompletion() {
    }

    public void flush() {
    }

    public void resume() {
        throw new IllegalStateException("ChangedSetBackedTransactionSynchronization does not support transaction suspension currently.");
    }

    public void suspend() {
        throw new IllegalStateException("ChangedSetBackedTransactionSynchronization does not support transaction suspension currently.");
    }
}

