/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.persistence.document.mongodb;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.internal.lang.annotation.ajcDeclareAnnotation;
import org.aspectj.internal.lang.annotation.ajcDeclareParents;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.FieldSignature;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.dao.DataAccessException;
import org.springframework.data.persistence.ChangeSet;
import org.springframework.data.persistence.ChangeSetBacked;
import org.springframework.data.persistence.ChangeSetPersister;
import org.springframework.data.persistence.HashMapChangeSet;
import org.springframework.data.persistence.document.DocumentBacked;
import org.springframework.data.persistence.document.DocumentBackedTransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class MongoDocumentBacking {
    private static final Log LOGGER;
    private ChangeSetPersister<Object> changeSetPersister;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MongoDocumentBacking ajc$perSingletonInstance;

    static {
        try {
            LOGGER = LogFactory.getLog(MongoDocumentBacking.class);
            MongoDocumentBacking.ajc$perSingletonInstance = new MongoDocumentBacking();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public void setChangeSetPersister(ChangeSetPersister<Object> changeSetPersister) {
        this.changeSetPersister = changeSetPersister;
    }

    @ajcDeclareParents(targetTypePattern="(@javax.persistence.Entity *)", parentTypes="org.springframework.data.persistence.document.DocumentBacked", isExtends=false)
    /* synthetic */ void ajc$declare_parents_1() {
    }

    @Transient
    @ajcDeclareAnnotation(pattern="@org.springframework.data.persistence.document.RelatedDocument * (@javax.persistence.Entity *).*", annotation="@Transient", kind="at_field")
    void ajc$declare_at_field_2() {
    }

    @Pointcut(value="(execution(org.springframework.data.persistence.document.DocumentBacked+.new(..)) && (!execution(org.springframework.data.persistence.document.DocumentBacked+.new(org.springframework.data.persistence.ChangeSet)) && this(entity)))", argNames="entity")
    /* synthetic */ void ajc$pointcut$$arbitraryUserConstructorOfChangeSetBackedObject$7f1(DocumentBacked entity) {
    }

    @Pointcut(value="(execution(org.springframework.data.persistence.document.DocumentBacked+.new(org.springframework.data.persistence.ChangeSet)) && (this(entity) && args(cs)))", argNames="entity,cs")
    /* synthetic */ void ajc$pointcut$$finderConstructorOfChangeSetBackedObject$8b3(DocumentBacked entity, ChangeSet cs) {
    }

    @Pointcut(value="(get(@org.springframework.data.persistence.document.RelatedDocument * org.springframework.data.persistence.document.DocumentBacked+.*) && (this(entity) && !get(* org.springframework.data.persistence.document.DocumentBacked.*)))", argNames="entity")
    protected /* synthetic */ void ajc$pointcut$$entityFieldGet$970(DocumentBacked entity) {
    }

    @Pointcut(value="(set(@org.springframework.data.persistence.document.RelatedDocument * org.springframework.data.persistence.document.DocumentBacked+.*) && (this(entity) && (args(newVal) && !set(* org.springframework.data.persistence.document.DocumentBacked.*))))", argNames="entity,newVal")
    protected /* synthetic */ void ajc$pointcut$$entityFieldSet$a1d(DocumentBacked entity, Object newVal) {
    }

    @Pointcut(value="(call(* javax.persistence.EntityManager.merge(java.lang.Object)) && (target(em) && args(entity)))", argNames="em,entity")
    public /* synthetic */ void ajc$pointcut$$entityManagerMerge$b17(EntityManager em, Object entity) {
    }

    @Around(value="entityManagerMerge(em, entity)", argNames="em,entity,ajc$aroundClosure")
    public Object ajc$around$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$1$a0440ef0(EntityManager em, Object entity, AroundClosure ajc$aroundClosure) {
        Object mergedEntity = ajc$aroundClosure.run(new Object[]{em, entity});
        if (entity instanceof DocumentBacked && mergedEntity instanceof DocumentBacked) {
            ((DocumentBacked)mergedEntity).ajc$interFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet(((DocumentBacked)entity).getChangeSet());
        }
        return mergedEntity;
    }

    private static void removeChangeSetValues(DocumentBacked entity) {
        LOGGER.debug((Object)("Removing all change-set values for " + entity));
        HashMapChangeSet nulledCs = new HashMapChangeSet();
        DocumentBacked documentEntity = entity;
        ChangeSetPersister changeSetPersister = documentEntity.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister();
        try {
            changeSetPersister.getPersistentState(documentEntity.getClass(), documentEntity.get_persistent_id(), documentEntity.getChangeSet());
        }
        catch (DataAccessException dataAccessException) {
        }
        catch (ChangeSetPersister.NotFoundException notFoundException) {}
        for (String key : entity.getChangeSet().getValues().keySet()) {
            nulledCs.set(key, null);
        }
        entity.setChangeSet((ChangeSet)nulledCs);
    }

    @Before(value="arbitraryUserConstructorOfChangeSetBackedObject(entity)", argNames="entity")
    public void ajc$before$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$2$adf21a1(DocumentBacked entity) {
        LOGGER.debug((Object)("User-defined constructor called on DocumentBacked object of class " + entity.getClass()));
        entity.setChangeSet((ChangeSet)new HashMapChangeSet());
        entity.ajc$interFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister(this.changeSetPersister);
        entity.ajc$interFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdTransactionSynchronization(new DocumentBackedTransactionSynchronization(this.changeSetPersister, entity));
    }

    private static void registerTransactionSynchronization(DocumentBacked entity) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            if (!TransactionSynchronizationManager.getSynchronizations().contains(entity.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdTransactionSynchronization())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding transaction synchronization for " + entity));
                }
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)entity.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdTransactionSynchronization());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Transaction synchronization already active for " + entity));
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Transaction synchronization is not active for " + entity));
        }
    }

    @Transient
    public static /* synthetic */ void ajc$interFieldInit$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet(DocumentBacked ajc$this_) {
    }

    @Transient
    public static /* synthetic */ void ajc$interFieldInit$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister(DocumentBacked ajc$this_) {
    }

    @Transient
    public static /* synthetic */ void ajc$interFieldInit$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdTransactionSynchronization(DocumentBacked ajc$this_) {
    }

    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$setChangeSet(DocumentBacked ajc$this_, ChangeSet cs) {
        ajc$this_.ajc$interFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet(cs);
    }

    public static ChangeSet ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$getChangeSet(DocumentBacked ajc$this_) {
        return ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet();
    }

    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$flush(DocumentBacked ajc$this_) {
        ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister().getPersistentId((ChangeSetBacked)ajc$this_, ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet());
        ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister().persistState((ChangeSetBacked)ajc$this_, ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet());
    }

    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$flush(DocumentBacked ajc$this_) {
        ajc$this_.flush();
    }

    public static Object ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$get_persistent_id(DocumentBacked ajc$this_) {
        return ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdChangeSetPersister().getPersistentId((ChangeSetBacked)ajc$this_, ajc$this_.ajc$interFieldGet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$changeSet());
    }

    @PostPersist
    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostPersist(DocumentBacked ajc$this_) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("JPA lifecycle event PrePersist: " + ajc$this_.getClass().getName()));
        }
        MongoDocumentBacking.registerTransactionSynchronization(ajc$this_);
    }

    @PostPersist
    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostPersist(DocumentBacked ajc$this_) {
        ajc$this_.itdPostPersist();
    }

    @PreUpdate
    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPreUpdate(DocumentBacked ajc$this_) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("JPA lifecycle event PreUpdate: " + ajc$this_.getClass().getName() + " :: " + ajc$this_));
        }
        MongoDocumentBacking.registerTransactionSynchronization(ajc$this_);
    }

    @PreUpdate
    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPreUpdate(DocumentBacked ajc$this_) {
        ajc$this_.itdPreUpdate();
    }

    @PostUpdate
    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostUpdate(DocumentBacked ajc$this_) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("JPA lifecycle event PostUpdate: " + ajc$this_.getClass().getName() + " :: " + ajc$this_));
        }
        MongoDocumentBacking.registerTransactionSynchronization(ajc$this_);
    }

    @PostUpdate
    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostUpdate(DocumentBacked ajc$this_) {
        ajc$this_.itdPostUpdate();
    }

    @PostRemove
    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostRemove(DocumentBacked ajc$this_) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("JPA lifecycle event PostRemove: " + ajc$this_.getClass().getName() + " :: " + ajc$this_));
        }
        MongoDocumentBacking.registerTransactionSynchronization(ajc$this_);
        MongoDocumentBacking.removeChangeSetValues(ajc$this_);
    }

    @PostRemove
    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostRemove(DocumentBacked ajc$this_) {
        ajc$this_.itdPostRemove();
    }

    @PostLoad
    public static void ajc$interMethod$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostLoad(DocumentBacked ajc$this_) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("JPA lifecycle event PostLoad: " + ajc$this_.getClass().getName() + " :: " + ajc$this_));
        }
        MongoDocumentBacking.registerTransactionSynchronization(ajc$this_);
    }

    @PostLoad
    public static /* synthetic */ void ajc$interMethodDispatch1$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_DocumentBacked$itdPostLoad(DocumentBacked ajc$this_) {
        ajc$this_.itdPostLoad();
    }

    @Around(value="entityFieldGet(entity)", argNames="entity,ajc$aroundClosure")
    public Object ajc$around$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$3$fcdbfd7d(DocumentBacked entity, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        Object fValue;
        Field f = this.field(thisJoinPoint);
        String propName = f.getName();
        MongoDocumentBacking.LOGGER.trace((Object)("GET " + f + " -> ChangeSet value property [" + propName + "] using: " + entity.getChangeSet()));
        if (entity.getChangeSet().getValues().get(propName) == null) {
            try {
                this.changeSetPersister.getPersistentState(entity.getClass(), entity.get_persistent_id(), entity.getChangeSet());
            }
            catch (ChangeSetPersister.NotFoundException notFoundException) {}
        }
        if ((fValue = entity.getChangeSet().getValues().get(propName)) != null) {
            return fValue;
        }
        return ajc$aroundClosure.run(new Object[]{entity});
    }

    @Around(value="entityFieldSet(entity, newVal)", argNames="entity,newVal,ajc$aroundClosure")
    public Object ajc$around$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$4$c3e51954(DocumentBacked entity, Object newVal, AroundClosure ajc$aroundClosure, JoinPoint thisJoinPoint) {
        Field f = this.field(thisJoinPoint);
        String propName = f.getName();
        MongoDocumentBacking.LOGGER.trace((Object)("SET " + f + " -> ChangeSet number value property [" + propName + "] with value=[" + newVal + "]"));
        entity.getChangeSet().set(propName, newVal);
        return ajc$aroundClosure.run(new Object[]{entity, newVal});
    }

    Field field(JoinPoint joinPoint) {
        FieldSignature fieldSignature = (FieldSignature)joinPoint.getSignature();
        return fieldSignature.getField();
    }

    public static MongoDocumentBacking aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org_springframework_data_persistence_document_mongodb_MongoDocumentBacking", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$changeSetPersister(MongoDocumentBacking mongoDocumentBacking, ChangeSetPersister changeSetPersister) {
        mongoDocumentBacking.changeSetPersister = changeSetPersister;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$org_springframework_data_persistence_document_mongodb_MongoDocumentBacking$LOGGER(Log log) {
        LOGGER = log;
    }
}

