/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.crossstore;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.crossstore.ChangeSet;
import org.springframework.data.crossstore.ChangeSetBacked;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.ClassUtils;

@Deprecated
public class MongoChangeSetPersister
implements ChangeSetPersister<Object> {
    private static final String ENTITY_CLASS = "_entity_class";
    private static final String ENTITY_ID = "_entity_id";
    private static final String ENTITY_FIELD_NAME = "_entity_field_name";
    private static final String ENTITY_FIELD_CLASS = "_entity_field_class";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MongoTemplate mongoTemplate;
    private EntityManagerFactory entityManagerFactory;

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void getPersistentState(Class<? extends ChangeSetBacked> entityClass, Object id, final ChangeSet changeSet) throws DataAccessException, ChangeSetPersister.NotFoundException {
        if (id == null) {
            this.log.debug("Unable to load MongoDB data for null id");
            return;
        }
        String collName = this.getCollectionNameForEntity(entityClass);
        final Document dbk = new Document();
        dbk.put(ENTITY_ID, id);
        dbk.put(ENTITY_CLASS, (Object)entityClass.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading MongoDB data for {}", (Object)dbk);
        }
        this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>(){

            public Object doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                for (Document dbo : collection.find((Bson)dbk)) {
                    String key = (String)dbo.get((Object)MongoChangeSetPersister.ENTITY_FIELD_NAME);
                    if (MongoChangeSetPersister.this.log.isDebugEnabled()) {
                        MongoChangeSetPersister.this.log.debug("Processing key: {}", (Object)key);
                    }
                    if (changeSet.getValues().containsKey(key)) continue;
                    String className = (String)dbo.get((Object)MongoChangeSetPersister.ENTITY_FIELD_CLASS);
                    if (className == null) {
                        throw new DataIntegrityViolationException("Unble to convert property " + key + ": Invalid metadata, " + MongoChangeSetPersister.ENTITY_FIELD_CLASS + " not available");
                    }
                    Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Object value = MongoChangeSetPersister.this.mongoTemplate.getConverter().read(clazz, (Object)dbo);
                    if (MongoChangeSetPersister.this.log.isDebugEnabled()) {
                        MongoChangeSetPersister.this.log.debug("Adding to ChangeSet: {}", (Object)key);
                    }
                    changeSet.set(key, value);
                }
                return null;
            }
        });
    }

    public Object getPersistentId(ChangeSetBacked entity, ChangeSet cs) throws DataAccessException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getPersistentId called on {}", (Object)entity);
        }
        if (this.entityManagerFactory == null) {
            throw new DataAccessResourceFailureException("EntityManagerFactory cannot be null");
        }
        return this.entityManagerFactory.getPersistenceUnitUtil().getIdentifier((Object)entity);
    }

    public Object persistState(ChangeSetBacked entity, ChangeSet cs) throws DataAccessException {
        String collName;
        if (cs == null) {
            this.log.debug("Flush: changeset was null, nothing to flush.");
            return 0L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush: changeset: {}", (Object)cs.getValues());
        }
        if (this.mongoTemplate.getCollection(collName = this.getCollectionNameForEntity(entity.getClass())) == null) {
            this.mongoTemplate.createCollection(collName);
        }
        for (String key : cs.getValues().keySet()) {
            if (key == null || key.startsWith("_") || key.equals("_id")) continue;
            Object value = cs.getValues().get(key);
            final Document dbQuery = new Document();
            dbQuery.put(ENTITY_ID, this.getPersistentId(entity, cs));
            dbQuery.put(ENTITY_CLASS, (Object)entity.getClass().getName());
            dbQuery.put(ENTITY_FIELD_NAME, (Object)key);
            final Document dbId = (Document)this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Document>(){

                public Document doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                    Document id = (Document)collection.find((Bson)dbQuery).first();
                    return id;
                }
            });
            if (value == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Flush: removing: {}", (Object)dbQuery);
                }
                this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>(){

                    public Object doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                        collection.deleteMany((Bson)dbQuery);
                        return null;
                    }
                });
                continue;
            }
            final Document dbDoc = new Document();
            dbDoc.putAll((Map)dbQuery);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Flush: saving: {}", (Object)dbQuery);
            }
            this.mongoTemplate.getConverter().write(value, (Object)dbDoc);
            dbDoc.put(ENTITY_FIELD_CLASS, (Object)value.getClass().getName());
            if (dbId != null) {
                dbDoc.put("_id", dbId.get((Object)"_id"));
            }
            this.mongoTemplate.execute(collName, (CollectionCallback)new CollectionCallback<Object>(){

                public Object doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                    if (dbId != null) {
                        collection.replaceOne(Filters.eq((String)"_id", (Object)dbId.get((Object)"_id")), (Object)dbDoc);
                    } else {
                        if (dbDoc.containsKey((Object)"_id") && dbDoc.get((Object)"_id") == null) {
                            dbDoc.remove((Object)"_id");
                        }
                        collection.insertOne((Object)dbDoc);
                    }
                    return null;
                }
            });
        }
        return 0L;
    }

    private String getCollectionNameForEntity(Class<? extends ChangeSetBacked> entityClass) {
        return this.mongoTemplate.getCollectionName(entityClass);
    }
}

