/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.DB;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

class DbHolder
extends ResourceHolderSupport {
    private static final Object DEFAULT_KEY = new Object();
    private final Map<Object, DB> dbMap = new ConcurrentHashMap<Object, DB>();

    public DbHolder(DB db) {
        this.addDB(db);
    }

    public DbHolder(Object key, DB db) {
        this.addDB(key, db);
    }

    public DB getDB() {
        return this.getDB(DEFAULT_KEY);
    }

    public DB getDB(Object key) {
        return this.dbMap.get(key);
    }

    public DB getAnyDB() {
        if (!this.dbMap.isEmpty()) {
            return this.dbMap.values().iterator().next();
        }
        return null;
    }

    public void addDB(DB session) {
        this.addDB(DEFAULT_KEY, session);
    }

    public void addDB(Object key, DB session) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)session, (String)"DB must not be null");
        this.dbMap.put(key, session);
    }

    public DB removeDB(Object key) {
        return this.dbMap.remove(key);
    }

    public boolean containsDB(DB session) {
        return this.dbMap.containsValue(session);
    }

    public boolean isEmpty() {
        return this.dbMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNotHoldNonDefaultDB() {
        Map<Object, DB> map = this.dbMap;
        synchronized (map) {
            return this.dbMap.isEmpty() || this.dbMap.size() == 1 && this.dbMap.containsKey(DEFAULT_KEY);
        }
    }
}

