/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.document.mongodb.MongoPropertyDescriptors;
import org.springframework.util.Assert;

class MongoBeanWrapper {
    private final ConfigurablePropertyAccessor accessor;
    private final MongoPropertyDescriptors descriptors;

    public MongoBeanWrapper(Object target, ConversionService conversionService, boolean fieldAccess) {
        Assert.notNull((Object)target);
        Assert.notNull((Object)conversionService);
        this.accessor = fieldAccess ? PropertyAccessorFactory.forDirectFieldAccess((Object)target) : PropertyAccessorFactory.forBeanPropertyAccess((Object)target);
        this.accessor.setConversionService(conversionService);
        this.descriptors = new MongoPropertyDescriptors(target.getClass());
    }

    public MongoPropertyDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Object getValue(MongoPropertyDescriptors.MongoPropertyDescriptor descriptor) {
        Assert.notNull((Object)descriptor);
        return this.accessor.getPropertyValue(descriptor.getName());
    }

    public void setValue(MongoPropertyDescriptors.MongoPropertyDescriptor descriptor, Object value) {
        Assert.notNull((Object)descriptor);
        this.accessor.setPropertyValue(descriptor.getName(), value);
    }
}

