/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.util.List;
import java.util.Set;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.CollectionOptions;
import org.springframework.data.document.mongodb.CursorPreparer;
import org.springframework.data.document.mongodb.DbCallback;
import org.springframework.data.document.mongodb.MongoReader;
import org.springframework.data.document.mongodb.MongoWriter;
import org.springframework.data.document.mongodb.query.IndexDefinition;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.query.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MongoOperations {
    public String getDefaultCollectionName();

    public DBCollection getDefaultCollection();

    public CommandResult executeCommand(String var1);

    public CommandResult executeCommand(DBObject var1);

    public <T> T execute(DbCallback<T> var1);

    public <T> T execute(CollectionCallback<T> var1);

    public <T> T execute(String var1, CollectionCallback<T> var2);

    public <T> T executeInSession(DbCallback<T> var1);

    public DBCollection createCollection(String var1);

    public DBCollection createCollection(String var1, CollectionOptions var2);

    public Set<String> getCollectionNames();

    public DBCollection getCollection(String var1);

    public boolean collectionExists(String var1);

    public void dropCollection(String var1);

    public <T> List<T> getCollection(Class<T> var1);

    public <T> List<T> getCollection(String var1, Class<T> var2);

    public <T> List<T> getCollection(String var1, Class<T> var2, MongoReader<T> var3);

    public void ensureIndex(IndexDefinition var1);

    public void ensureIndex(String var1, IndexDefinition var2);

    public <T> T findOne(Query var1, Class<T> var2);

    public <T> T findOne(Query var1, Class<T> var2, MongoReader<T> var3);

    public <T> T findOne(String var1, Query var2, Class<T> var3);

    public <T> T findOne(String var1, Query var2, Class<T> var3, MongoReader<T> var4);

    public <T> List<T> find(Query var1, Class<T> var2);

    public <T> List<T> find(Query var1, Class<T> var2, MongoReader<T> var3);

    public <T> List<T> find(String var1, Query var2, Class<T> var3);

    public <T> List<T> find(String var1, Query var2, Class<T> var3, MongoReader<T> var4);

    public <T> List<T> find(String var1, Query var2, Class<T> var3, CursorPreparer var4);

    public void insert(Object var1);

    public void insert(String var1, Object var2);

    public <T> void insert(T var1, MongoWriter<T> var2);

    public <T> void insert(String var1, T var2, MongoWriter<T> var3);

    public void insertList(List<? extends Object> var1);

    public void insertList(String var1, List<? extends Object> var2);

    public <T> void insertList(List<? extends T> var1, MongoWriter<T> var2);

    public <T> void insertList(String var1, List<? extends T> var2, MongoWriter<T> var3);

    public void save(Object var1);

    public void save(String var1, Object var2);

    public <T> void save(T var1, MongoWriter<T> var2);

    public <T> void save(String var1, T var2, MongoWriter<T> var3);

    public WriteResult updateFirst(Query var1, Update var2);

    public WriteResult updateFirst(String var1, Query var2, Update var3);

    public WriteResult updateMulti(Query var1, Update var2);

    public WriteResult updateMulti(String var1, Query var2, Update var3);

    public void remove(Query var1);

    public void remove(String var1, Query var2);
}

