/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.CollectionOptions;
import org.springframework.data.document.mongodb.CursorPreparer;
import org.springframework.data.document.mongodb.DbCallback;
import org.springframework.data.document.mongodb.MongoConverter;
import org.springframework.data.document.mongodb.MongoDbUtils;
import org.springframework.data.document.mongodb.MongoExceptionTranslator;
import org.springframework.data.document.mongodb.MongoOperations;
import org.springframework.data.document.mongodb.MongoPropertyDescriptors;
import org.springframework.data.document.mongodb.MongoReader;
import org.springframework.data.document.mongodb.MongoWriter;
import org.springframework.data.document.mongodb.SimpleMongoConverter;
import org.springframework.data.document.mongodb.WriteResultChecking;
import org.springframework.data.document.mongodb.query.IndexDefinition;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.query.Update;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTemplate
implements InitializingBean,
MongoOperations {
    private static final Log LOGGER = LogFactory.getLog(MongoTemplate.class);
    private static final String ID = "_id";
    private WriteConcern writeConcern = null;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    private final MongoConverter mongoConverter;
    private final Mongo mongo;
    private final MongoExceptionTranslator exceptionTranslator = new MongoExceptionTranslator();
    private String defaultCollectionName;
    private String databaseName;
    private String username;
    private String password;

    public MongoTemplate(Mongo mongo, String databaseName) {
        this(mongo, databaseName, null, null, null, null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, WriteConcern writeConcern, WriteResultChecking writeResultChecking) {
        this(mongo, databaseName, null, null, writeConcern, writeResultChecking);
    }

    public MongoTemplate(Mongo mongo, String databaseName, String defaultCollectionName) {
        this(mongo, databaseName, defaultCollectionName, null, null, null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, String defaultCollectionName, WriteConcern writeConcern, WriteResultChecking writeResultChecking) {
        this(mongo, databaseName, defaultCollectionName, null, writeConcern, writeResultChecking);
    }

    public MongoTemplate(Mongo mongo, String databaseName, String defaultCollectionName, MongoConverter mongoConverter) {
        this(mongo, databaseName, defaultCollectionName, mongoConverter, null, null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, String defaultCollectionName, MongoConverter mongoConverter, WriteConcern writeConcern, WriteResultChecking writeResultChecking) {
        Assert.notNull((Object)mongo);
        Assert.notNull((Object)databaseName);
        this.mongoConverter = mongoConverter == null ? new SimpleMongoConverter() : mongoConverter;
        this.defaultCollectionName = defaultCollectionName;
        this.mongo = mongo;
        this.databaseName = databaseName;
        this.writeConcern = writeConcern;
        if (writeResultChecking != null) {
            this.writeResultChecking = writeResultChecking;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultCollectionName(String defaultCollectionName) {
        this.defaultCollectionName = defaultCollectionName;
    }

    public void setDatabaseName(String databaseName) {
        Assert.notNull((Object)databaseName);
        this.databaseName = databaseName;
    }

    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    @Override
    public String getDefaultCollectionName() {
        return this.defaultCollectionName;
    }

    @Override
    public DBCollection getDefaultCollection() {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollection(MongoTemplate.this.getDefaultCollectionName());
            }
        });
    }

    @Override
    public CommandResult executeCommand(String jsonCommand) {
        return this.executeCommand((DBObject)JSON.parse((String)jsonCommand));
    }

    @Override
    public CommandResult executeCommand(final DBObject command) {
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return db.command(command);
            }
        });
        String error = result.getErrorMessage();
        if (error != null) {
            LOGGER.warn((Object)("Command execution of " + command.toString() + " failed: " + error));
        }
        return result;
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action);
        try {
            DB db = this.getDb();
            return action.doInDB(db);
        }
        catch (MongoException e) {
            throw this.potentiallyConvertRuntimeException((RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> T execute(CollectionCallback<T> callback) {
        return this.execute(this.getDefaultCollectionName(), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull(callback);
        try {
            DBCollection collection = this.getDb().getCollection(collectionName);
            return callback.doInCollection(collection);
        }
        catch (MongoException e) {
            throw this.potentiallyConvertRuntimeException((RuntimeException)((Object)e));
        }
    }

    private <T> T execute(CollectionCallback<DBObject> collectionCallback, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            T result = objectCallback.doWith(collectionCallback.doInCollection(this.getCollection(collectionName)));
            return result;
        }
        catch (MongoException e) {
            throw this.potentiallyConvertRuntimeException((RuntimeException)((Object)e));
        }
    }

    private <T> List<T> executeEach(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            DBCursor cursor = collectionCallback.doInCollection(this.getCollection(collectionName));
            if (preparer != null) {
                cursor = preparer.prepare(cursor);
            }
            ArrayList<T> result = new ArrayList<T>();
            for (DBObject object : cursor) {
                result.add(objectCallback.doWith(object));
            }
            return result;
        }
        catch (MongoException e) {
            throw this.potentiallyConvertRuntimeException((RuntimeException)((Object)e));
        }
    }

    @Override
    public <T> T executeInSession(final DbCallback<T> action) {
        return this.execute(new DbCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInDB(DB db) throws MongoException, DataAccessException {
                try {
                    db.requestStart();
                    Object t = action.doInDB(db);
                    return t;
                }
                finally {
                    db.requestDone();
                }
            }
        });
    }

    @Override
    public DBCollection createCollection(String collectionName) {
        return this.doCreateCollection(collectionName, (DBObject)new BasicDBObject());
    }

    @Override
    public DBCollection createCollection(String collectionName, CollectionOptions collectionOptions) {
        return this.doCreateCollection(collectionName, this.convertToDbObject(collectionOptions));
    }

    @Override
    public DBCollection getCollection(final String collectionName) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollection(collectionName);
            }
        });
    }

    @Override
    public boolean collectionExists(final String collectionName) {
        return this.execute(new DbCallback<Boolean>(){

            @Override
            public Boolean doInDB(DB db) throws MongoException, DataAccessException {
                return db.collectionExists(collectionName);
            }
        });
    }

    @Override
    public void dropCollection(String collectionName) {
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.drop();
                return null;
            }
        });
    }

    @Override
    public void ensureIndex(IndexDefinition indexDefinition) {
        this.ensureIndex(this.getDefaultCollectionName(), indexDefinition);
    }

    @Override
    public void ensureIndex(String collectionName, final IndexDefinition indexDefinition) {
        this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject indexOptions = indexDefinition.getIndexOptions();
                if (indexOptions != null) {
                    collection.ensureIndex(indexDefinition.getIndexObject(), indexOptions);
                } else {
                    collection.ensureIndex(indexDefinition.getIndexObject());
                }
                return null;
            }
        });
    }

    @Override
    public <T> T findOne(Query query, Class<T> targetClass) {
        return this.findOne(this.getDefaultCollectionName(), query, targetClass);
    }

    @Override
    public <T> T findOne(Query query, Class<T> targetClass, MongoReader<T> reader) {
        return this.findOne(this.getDefaultCollectionName(), query, targetClass, reader);
    }

    @Override
    public <T> T findOne(String collectionName, Query query, Class<T> targetClass) {
        return this.findOne(collectionName, query, targetClass, null);
    }

    @Override
    public <T> T findOne(String collectionName, Query query, Class<T> targetClass, MongoReader<T> reader) {
        return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), targetClass, reader);
    }

    @Override
    public <T> List<T> find(Query query, Class<T> targetClass) {
        return this.find(this.getDefaultCollectionName(), query, targetClass);
    }

    @Override
    public <T> List<T> find(Query query, Class<T> targetClass, MongoReader<T> reader) {
        return this.find(this.getDefaultCollectionName(), query, targetClass, reader);
    }

    @Override
    public <T> List<T> find(String collectionName, final Query query, Class<T> targetClass) {
        CursorPreparer cursorPreparer = null;
        if (query.getSkip() > 0 || query.getLimit() > 0 || query.getSortObject() != null) {
            cursorPreparer = new CursorPreparer(){

                public DBCursor prepare(DBCursor cursor) {
                    DBCursor cursorToUse = cursor;
                    try {
                        if (query.getSkip() > 0) {
                            cursorToUse = cursorToUse.skip(query.getSkip());
                        }
                        if (query.getLimit() > 0) {
                            cursorToUse = cursorToUse.limit(query.getLimit());
                        }
                        if (query.getSortObject() != null) {
                            cursorToUse = cursorToUse.sort(query.getSortObject());
                        }
                    }
                    catch (MongoException e) {
                        throw MongoTemplate.this.potentiallyConvertRuntimeException((RuntimeException)((Object)e));
                    }
                    return cursorToUse;
                }
            };
        }
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), targetClass, cursorPreparer);
    }

    @Override
    public <T> List<T> find(String collectionName, Query query, Class<T> targetClass, MongoReader<T> reader) {
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), targetClass, reader);
    }

    @Override
    public <T> List<T> find(String collectionName, Query query, Class<T> targetClass, CursorPreparer preparer) {
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), targetClass, preparer);
    }

    @Override
    public void insert(Object objectToSave) {
        this.insert(this.getRequiredDefaultCollectionName(), objectToSave);
    }

    @Override
    public void insert(String collectionName, Object objectToSave) {
        this.insert(collectionName, objectToSave, this.mongoConverter);
    }

    @Override
    public <T> void insert(T objectToSave, MongoWriter<T> writer) {
        this.insert(this.getDefaultCollectionName(), objectToSave, writer);
    }

    @Override
    public <T> void insert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BasicDBObject dbDoc = new BasicDBObject();
        writer.write(objectToSave, (DBObject)dbDoc);
        Object id = this.insertDBObject(collectionName, (DBObject)dbDoc);
        this.populateIdIfNecessary(objectToSave, id);
    }

    @Override
    public void insertList(List<? extends Object> listToSave) {
        this.insertList(this.getRequiredDefaultCollectionName(), listToSave);
    }

    @Override
    public void insertList(String collectionName, List<? extends Object> listToSave) {
        this.insertList(collectionName, listToSave, this.mongoConverter);
    }

    @Override
    public <T> void insertList(List<? extends T> listToSave, MongoWriter<T> writer) {
        this.insertList(this.getDefaultCollectionName(), listToSave, writer);
    }

    @Override
    public <T> void insertList(String collectionName, List<? extends T> listToSave, MongoWriter<T> writer) {
        Assert.notNull(writer);
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>();
        for (T o : listToSave) {
            BasicDBObject dbDoc = new BasicDBObject();
            writer.write(o, (DBObject)dbDoc);
            dbObjectList.add((DBObject)dbDoc);
        }
        List<ObjectId> ids = this.insertDBObjectList(collectionName, dbObjectList);
        for (int i = 0; i < listToSave.size(); ++i) {
            if (i >= ids.size()) continue;
            this.populateIdIfNecessary(listToSave.get(i), ids.get(i));
        }
    }

    @Override
    public void save(Object objectToSave) {
        this.save(this.getRequiredDefaultCollectionName(), objectToSave);
    }

    @Override
    public void save(String collectionName, Object objectToSave) {
        this.save(collectionName, objectToSave, this.mongoConverter);
    }

    @Override
    public <T> void save(T objectToSave, MongoWriter<T> writer) {
        this.save(this.getDefaultCollectionName(), objectToSave, writer);
    }

    @Override
    public <T> void save(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BasicDBObject dbDoc = new BasicDBObject();
        writer.write(objectToSave, (DBObject)dbDoc);
        ObjectId id = this.saveDBObject(collectionName, (DBObject)dbDoc);
        this.populateIdIfNecessary(objectToSave, id);
    }

    protected Object insertDBObject(String collectionName, final DBObject dbDoc) {
        if (dbDoc.keySet().isEmpty()) {
            return null;
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                if (MongoTemplate.this.writeConcern == null) {
                    collection.insert(new DBObject[]{dbDoc});
                } else {
                    collection.insert(dbDoc, MongoTemplate.this.writeConcern);
                }
                return dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    protected List<ObjectId> insertDBObjectList(String collectionName, final List<DBObject> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Collections.emptyList();
        }
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                if (MongoTemplate.this.writeConcern == null) {
                    collection.insert(dbDocList);
                } else {
                    collection.insert(dbDocList.toArray((DBObject[])new BasicDBObject[dbDocList.size()]), MongoTemplate.this.writeConcern);
                }
                return null;
            }
        });
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (DBObject dbo : dbDocList) {
            Object id = dbo.get(ID);
            if (id instanceof ObjectId) {
                ids.add((ObjectId)id);
                continue;
            }
            ids.add(null);
        }
        return ids;
    }

    protected ObjectId saveDBObject(String collectionName, final DBObject dbDoc) {
        if (dbDoc.keySet().isEmpty()) {
            return null;
        }
        return this.execute(collectionName, new CollectionCallback<ObjectId>(){

            @Override
            public ObjectId doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                if (MongoTemplate.this.writeConcern == null) {
                    collection.save(dbDoc);
                } else {
                    collection.save(dbDoc, MongoTemplate.this.writeConcern);
                }
                return (ObjectId)dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    @Override
    public WriteResult updateFirst(Query query, Update update) {
        return this.updateFirst(this.getRequiredDefaultCollectionName(), query, update);
    }

    @Override
    public WriteResult updateFirst(String collectionName, final Query query, final Update update) {
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteResult wr = MongoTemplate.this.writeConcern == null ? collection.update(query.getQueryObject(), update.getUpdateObject()) : collection.update(query.getQueryObject(), update.getUpdateObject(), false, false, MongoTemplate.this.writeConcern);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, query.getQueryObject(), "update with '" + update.getUpdateObject() + "'");
                return wr;
            }
        });
    }

    @Override
    public WriteResult updateMulti(Query query, Update update) {
        return this.updateMulti(this.getRequiredDefaultCollectionName(), query, update);
    }

    @Override
    public WriteResult updateMulti(String collectionName, final Query query, final Update update) {
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteResult wr = null;
                wr = MongoTemplate.this.writeConcern == null ? collection.updateMulti(query.getQueryObject(), update.getUpdateObject()) : collection.update(query.getQueryObject(), update.getUpdateObject(), false, true, MongoTemplate.this.writeConcern);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, query.getQueryObject(), "update with '" + update.getUpdateObject() + "'");
                return wr;
            }
        });
    }

    @Override
    public void remove(Query query) {
        this.remove(this.getRequiredDefaultCollectionName(), query);
    }

    @Override
    public void remove(String collectionName, final Query query) {
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteResult wr = null;
                wr = MongoTemplate.this.writeConcern == null ? collection.remove(query.getQueryObject()) : collection.remove(query.getQueryObject(), MongoTemplate.this.writeConcern);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, query.getQueryObject(), "remove");
                return null;
            }
        });
    }

    @Override
    public <T> List<T> getCollection(Class<T> targetClass) {
        return this.executeEach(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, targetClass), this.getDefaultCollectionName());
    }

    @Override
    public <T> List<T> getCollection(String collectionName, Class<T> targetClass) {
        return this.executeEach(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, targetClass), collectionName);
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(new DbCallback<Set<String>>(){

            @Override
            public Set<String> doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollectionNames();
            }
        });
    }

    @Override
    public <T> List<T> getCollection(String collectionName, Class<T> targetClass, MongoReader<T> reader) {
        return this.executeEach(new FindCallback(null), null, new ReadDbObjectCallback<T>(reader, targetClass), collectionName);
    }

    public DB getDb() {
        return MongoDbUtils.getDB(this.mongo, this.databaseName, this.username, this.password == null ? null : this.password.toCharArray());
    }

    protected DBCollection doCreateCollection(final String collectionName, final DBObject collectionOptions) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.createCollection(collectionName, collectionOptions);
            }
        });
    }

    protected <T> T doFindOne(String collectionName, DBObject query, DBObject fields, Class<T> targetClass, MongoReader<T> reader) {
        MongoConverter readerToUse = reader;
        if (readerToUse == null) {
            readerToUse = this.mongoConverter;
        }
        this.substituteMappedIdIfNecessary(query, targetClass, readerToUse);
        return (T)this.execute(new FindOneCallback(query, fields), new ReadDbObjectCallback<Object>(readerToUse, targetClass), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> targetClass, CursorPreparer preparer) {
        this.substituteMappedIdIfNecessary(query, targetClass, this.mongoConverter);
        return this.executeEach(new FindCallback(query, fields), preparer, new ReadDbObjectCallback<Object>(this.mongoConverter, targetClass), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> targetClass, MongoReader<T> reader) {
        this.substituteMappedIdIfNecessary(query, targetClass, reader);
        return this.executeEach(new FindCallback(query, fields), null, new ReadDbObjectCallback<T>(reader, targetClass), collectionName);
    }

    protected DBObject convertToDbObject(CollectionOptions collectionOptions) {
        BasicDBObject dbo = new BasicDBObject();
        if (collectionOptions != null) {
            if (collectionOptions.getCapped() != null) {
                dbo.put("capped", (Object)collectionOptions.getCapped());
            }
            if (collectionOptions.getSize() != null) {
                dbo.put("size", (Object)collectionOptions.getSize());
            }
            if (collectionOptions.getMaxDocuments() != null) {
                dbo.put("max", (Object)collectionOptions.getMaxDocuments());
            }
        }
        return dbo;
    }

    protected void populateIdIfNecessary(Object savedObject, Object id) {
        if (id == null) {
            return;
        }
        ConfigurablePropertyAccessor bw = PropertyAccessorFactory.forDirectFieldAccess((Object)savedObject);
        MongoPropertyDescriptors.MongoPropertyDescriptor idDescriptor = new MongoPropertyDescriptors(savedObject.getClass()).getIdDescriptor();
        if (idDescriptor == null) {
            return;
        }
        if (bw.getPropertyValue(idDescriptor.getName()) == null) {
            Object target = null;
            target = id instanceof ObjectId ? this.mongoConverter.convertObjectId((ObjectId)id, idDescriptor.getPropertyType()) : id;
            bw.setPropertyValue(idDescriptor.getName(), target);
        }
    }

    protected void substituteMappedIdIfNecessary(DBObject query, Class<?> targetClass, MongoReader<?> reader) {
        MongoPropertyDescriptors.MongoPropertyDescriptor descriptor;
        MongoConverter converter = null;
        if (!(reader instanceof SimpleMongoConverter)) {
            return;
        }
        converter = (MongoConverter)reader;
        String idKey = null;
        if (query.containsField("id")) {
            idKey = "id";
        }
        if (query.containsField(ID)) {
            idKey = ID;
        }
        if (idKey == null) {
            return;
        }
        try {
            descriptor = new MongoPropertyDescriptors.MongoPropertyDescriptor(new PropertyDescriptor(idKey, targetClass));
        }
        catch (IntrospectionException e) {
            return;
        }
        if (descriptor.isIdProperty() && descriptor.isOfIdType()) {
            Object value = query.get(idKey);
            ObjectId newValue = null;
            try {
                if (value instanceof String && ObjectId.isValid((String)((String)value))) {
                    newValue = converter.convertObjectId(value);
                }
            }
            catch (ConversionFailedException iae) {
                LOGGER.warn((Object)("Unable to convert the String " + value + " to an ObjectId"));
            }
            query.removeField(idKey);
            if (newValue != null) {
                query.put(ID, (Object)newValue);
            } else {
                query.put(ID, value);
            }
        }
    }

    private String getRequiredDefaultCollectionName() {
        String name = this.getDefaultCollectionName();
        if (name == null) {
            throw new IllegalStateException("No 'defaultCollection' or 'defaultCollectionName' specified. Check configuration of MongoTemplate.");
        }
        return name;
    }

    private void handleAnyWriteResultErrors(WriteResult wr, DBObject query, String operation) {
        if (WriteResultChecking.NONE == this.writeResultChecking) {
            return;
        }
        String error = wr.getError();
        int n = wr.getN();
        if (error != null) {
            String message = "Execution of '" + operation + (query == null ? "" : "' using '" + query.toString() + "' query") + " failed: " + error;
            if (WriteResultChecking.EXCEPTION == this.writeResultChecking) {
                throw new DataIntegrityViolationException(message);
            }
            LOGGER.error((Object)message);
        } else if (n == 0) {
            String message = "Execution of '" + operation + (query == null ? "" : "' using '" + query.toString() + "' query") + " did not succeed: 0 documents updated";
            if (WriteResultChecking.EXCEPTION == this.writeResultChecking) {
                throw new DataIntegrityViolationException(message);
            }
            LOGGER.warn((Object)message);
        }
    }

    private RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    public void afterPropertiesSet() {
        if (this.getDefaultCollectionName() != null && !this.collectionExists(this.getDefaultCollectionName())) {
            this.createCollection(this.getDefaultCollectionName(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadDbObjectCallback<T>
    implements DbObjectCallback<T> {
        private final MongoReader<? super T> reader;
        private final Class<T> type;

        public ReadDbObjectCallback(MongoReader<? super T> reader, Class<T> type) {
            this.reader = reader;
            this.type = type;
        }

        @Override
        public T doWith(DBObject object) {
            return this.reader.read(this.type, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DbObjectCallback<T> {
        public T doWith(DBObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindCallback
    implements CollectionCallback<DBCursor> {
        private final DBObject query;
        private final DBObject fields;

        public FindCallback(DBObject query) {
            this(query, null);
        }

        public FindCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBCursor doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                return collection.find(this.query);
            }
            return collection.find(this.query, this.fields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindOneCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;

        public FindOneCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                return collection.findOne(this.query);
            }
            return collection.findOne(this.query, this.fields);
        }
    }
}

