/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.config;

import org.springframework.data.document.mongodb.repository.MongoRepository;
import org.springframework.data.document.mongodb.repository.MongoRepositoryFactoryBean;
import org.springframework.data.repository.config.AutomaticRepositoryConfigInformation;
import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.ManualRepositoryConfigInformation;
import org.springframework.data.repository.config.RepositoryConfig;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMongoRepositoryConfiguration
extends RepositoryConfig<MongoRepositoryConfiguration, SimpleMongoRepositoryConfiguration> {
    private static final String MONGO_TEMPLATE_REF = "mongo-template-ref";
    private static final String DEFAULT_MONGO_TEMPLATE_REF = "mongoTemplate";

    protected SimpleMongoRepositoryConfiguration(Element repositoriesElement) {
        super(repositoriesElement, MongoRepositoryFactoryBean.class.getName());
    }

    public String getMongoTemplateRef() {
        String templateRef = this.getSource().getAttribute(MONGO_TEMPLATE_REF);
        return StringUtils.hasText((String)templateRef) ? templateRef : DEFAULT_MONGO_TEMPLATE_REF;
    }

    public MongoRepositoryConfiguration getAutoconfigRepositoryInformation(String interfaceName) {
        return new AutomaticMongoRepositoryConfiguration(interfaceName, this);
    }

    public Class<?> getRepositoryBaseInterface() {
        return MongoRepository.class;
    }

    protected MongoRepositoryConfiguration createSingleRepositoryConfigInformationFor(Element element) {
        return new ManualMongoRepositoryConfiguration(element, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutomaticMongoRepositoryConfiguration
    extends AutomaticRepositoryConfigInformation<SimpleMongoRepositoryConfiguration>
    implements MongoRepositoryConfiguration {
        public AutomaticMongoRepositoryConfiguration(String interfaceName, SimpleMongoRepositoryConfiguration parent) {
            super(interfaceName, (CommonRepositoryConfigInformation)parent);
        }

        @Override
        public String getMongoTemplateRef() {
            return ((SimpleMongoRepositoryConfiguration)this.getParent()).getMongoTemplateRef();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManualMongoRepositoryConfiguration
    extends ManualRepositoryConfigInformation<SimpleMongoRepositoryConfiguration>
    implements MongoRepositoryConfiguration {
        public ManualMongoRepositoryConfiguration(Element element, SimpleMongoRepositoryConfiguration parent) {
            super(element, (CommonRepositoryConfigInformation)parent);
        }

        @Override
        public String getMongoTemplateRef() {
            return this.getAttribute(SimpleMongoRepositoryConfiguration.MONGO_TEMPLATE_REF);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MongoRepositoryConfiguration
    extends SingleRepositoryConfigInformation<SimpleMongoRepositoryConfiguration> {
        public String getMongoTemplateRef();
    }
}

