/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import org.springframework.data.document.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Btree Metrics")
public class BtreeIndexCounters
extends AbstractMonitor {
    public BtreeIndexCounters(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Accesses")
    public int getAccesses() {
        return this.getBtree("accesses");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Hits")
    public int getHits() {
        return this.getBtree("hits");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Misses")
    public int getMisses() {
        return this.getBtree("misses");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Resets")
    public int getResets() {
        return this.getBtree("resets");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Miss Ratio")
    public int getMissRatio() {
        return this.getBtree("missRatio");
    }

    private int getBtree(String key) {
        String message;
        DBObject indexCounters = (DBObject)this.getServerStatus().get("indexCounters");
        if (indexCounters.get("note") != null && (message = (String)indexCounters.get("note")).contains("not supported")) {
            return -1;
        }
        DBObject btree = (DBObject)indexCounters.get("btree");
        return (Integer)btree.get(key);
    }
}

