/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.Mongo;
import org.springframework.data.document.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Connection metrics")
public class ConnectionMetrics
extends AbstractMonitor {
    public ConnectionMetrics(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Current Connections")
    public int getCurrent() {
        return this.getConnectionData("current", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Available Connections")
    public int getAvailable() {
        return this.getConnectionData("available", Integer.class);
    }

    private <T> T getConnectionData(String key, Class<T> targetClass) {
        DBObject mem = (DBObject)this.getServerStatus().get("connections");
        return (T)mem.get(key);
    }
}

