/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.document.InvalidDocumentStoreApiUsageException;
import org.springframework.data.document.mongodb.query.CriteriaDefinition;
import org.springframework.data.document.mongodb.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria
implements CriteriaDefinition {
    private String key;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private Object isValue = null;

    public Criteria(String key) {
        this.key = key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria is(Object o) {
        if (this.isValue != null) {
            throw new InvalidDocumentStoreApiUsageException("Multiple 'is' values declared.");
        }
        this.isValue = o;
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put("$lt", o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put("$lte", o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put("$gt", o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put("$gte", o);
        return this;
    }

    public Criteria in(Object ... o) {
        this.criteria.put("$in", o);
        return this;
    }

    public Criteria nin(Object ... o) {
        this.criteria.put("$min", o);
        return this;
    }

    public Criteria mod(Number value, Number remainder) {
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(value);
        l.add(remainder);
        this.criteria.put("$mod", l);
        return this;
    }

    public Criteria all(Object o) {
        this.criteria.put("$is", o);
        return this;
    }

    public Criteria size(int s) {
        this.criteria.put("$size", s);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put("$exists", b);
        return this;
    }

    public Criteria type(int t) {
        this.criteria.put("$type", t);
        return this;
    }

    public Criteria not() {
        this.criteria.put("$not", null);
        return this;
    }

    public Criteria regex(String re) {
        this.criteria.put("$regex", re);
        return this;
    }

    public void or(List<Query> queries) {
        this.criteria.put("$or", queries);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public DBObject getCriteriaObject() {
        BasicDBObject dbo = new BasicDBObject();
        boolean not = false;
        for (String k : this.criteria.keySet()) {
            if (not) {
                BasicDBObject notDbo = new BasicDBObject();
                notDbo.put(k, this.convertValueIfNecessary(this.criteria.get(k)));
                dbo.put("$not", (Object)notDbo);
                not = false;
                continue;
            }
            if ("$not".equals(k)) {
                not = true;
                continue;
            }
            dbo.put(k, this.convertValueIfNecessary(this.criteria.get(k)));
        }
        BasicDBObject queryCriteria = new BasicDBObject();
        if (this.isValue != null) {
            queryCriteria.put(this.key, this.convertValueIfNecessary(this.isValue));
            queryCriteria.putAll((BSONObject)dbo);
        } else {
            queryCriteria.put(this.key, (Object)dbo);
        }
        return queryCriteria;
    }

    private Object convertValueIfNecessary(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }
}

