/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.springframework.data.document.mongodb.query.IndexDefinition;

public class GeospatialIndex
implements IndexDefinition {
    private String keyField;
    private String name;
    private Integer min = null;
    private Integer max = null;

    public GeospatialIndex() {
    }

    public GeospatialIndex(String key) {
        this.keyField = key;
    }

    public GeospatialIndex named(String name) {
        this.name = name;
        return this;
    }

    public GeospatialIndex withMin(int min) {
        this.min = min;
        return this;
    }

    public GeospatialIndex withMax(int max) {
        this.max = max;
        return this;
    }

    public DBObject getIndexObject() {
        BasicDBObject dbo = new BasicDBObject();
        dbo.put(this.keyField, (Object)"2d");
        return dbo;
    }

    public DBObject getIndexOptions() {
        if (this.name == null && this.min == null && this.max == null) {
            return null;
        }
        BasicDBObject dbo = new BasicDBObject();
        if (this.name != null) {
            dbo.put("name", (Object)this.name);
        }
        if (this.min != null) {
            dbo.put("min", (Object)this.min);
        }
        if (this.max != null) {
            dbo.put("max", (Object)this.max);
        }
        return dbo;
    }
}

