/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class Update {
    private HashMap<String, Object> criteria = new LinkedHashMap<String, Object>();

    public Update set(String key, Object value) {
        this.criteria.put("$set", Collections.singletonMap(key, this.convertValueIfNecessary(value)));
        return this;
    }

    public Update unset(String key) {
        this.criteria.put("$unset", Collections.singletonMap(key, 1));
        return this;
    }

    public Update inc(String key, Number inc) {
        this.criteria.put("$inc", Collections.singletonMap(key, inc));
        return this;
    }

    public Update push(String key, Object value) {
        this.criteria.put("$push", Collections.singletonMap(key, this.convertValueIfNecessary(value)));
        return this;
    }

    public Update pushAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = this.convertValueIfNecessary(values[i]);
        }
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)convertedValues);
        this.criteria.put("$pushAll", keyValue);
        return this;
    }

    public Update addToSet(String key, Object value) {
        this.criteria.put("$addToSet", Collections.singletonMap(key, this.convertValueIfNecessary(value)));
        return this;
    }

    public Update pop(String key, Position pos) {
        this.criteria.put("$pop", Collections.singletonMap(key, pos == Position.FIRST ? -1 : 1));
        return this;
    }

    public Update pull(String key, Object value) {
        this.criteria.put("$pull", Collections.singletonMap(key, this.convertValueIfNecessary(value)));
        return this;
    }

    public Update pullAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = this.convertValueIfNecessary(values[i]);
        }
        BasicDBObject keyValue = new BasicDBObject();
        keyValue.put(key, (Object)convertedValues);
        this.criteria.put("$pullAll", keyValue);
        return this;
    }

    public Update rename(String oldName, String newName) {
        this.criteria.put("$rename", Collections.singletonMap(oldName, newName));
        return this;
    }

    public DBObject getUpdateObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.criteria.keySet()) {
            dbo.put(k, this.criteria.get(k));
        }
        return dbo;
    }

    protected Object convertValueIfNecessary(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        LAST,
        FIRST;

    }
}

