/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.repository.support.IdAware;
import org.springframework.data.repository.support.IsNewAware;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoEntityInformation
implements IsNewAware,
IdAware {
    private static final List<String> FIELD_NAMES = Arrays.asList("ID", "id", "_id");
    private Field field;

    public MongoEntityInformation(Class<?> domainClass) {
        for (String name : FIELD_NAMES) {
            Field candidate = ReflectionUtils.findField(domainClass, (String)name);
            if (candidate == null) continue;
            ReflectionUtils.makeAccessible((Field)candidate);
            this.field = candidate;
            break;
        }
        if (this.field == null) {
            throw new IllegalArgumentException(String.format("Given domain class %s does not contain an id property!", domainClass.getName()));
        }
    }

    public boolean isNew(Object entity) {
        return null == ReflectionUtils.getField((Field)this.field, (Object)entity);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Object getId(Object entity) {
        return ReflectionUtils.getField((Field)this.field, (Object)entity);
    }
}

