/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.repository.MongoQueryCreator;
import org.springframework.data.document.mongodb.repository.QueryUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.SimpleParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class MongoQuery
implements RepositoryQuery {
    private final QueryMethod method;
    private final MongoTemplate template;
    private final PartTree tree;

    public MongoQuery(QueryMethod method, MongoTemplate template) {
        Assert.notNull((Object)template);
        Assert.notNull((Object)method);
        this.method = method;
        this.template = template;
        this.tree = new PartTree(method.getName(), method.getDomainClass());
    }

    public Object execute(Object[] parameters) {
        SimpleParameterAccessor accessor = new SimpleParameterAccessor(this.method.getParameters(), parameters);
        MongoQueryCreator creator = new MongoQueryCreator(this.tree, accessor, this.template.getConverter());
        Query query = (Query)creator.createQuery();
        if (this.method.isCollectionQuery()) {
            return new CollectionExecution().execute(query);
        }
        if (this.method.isPageQuery()) {
            return new PagedExecution(creator, accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution().execute(query);
    }

    class SingleEntityExecution
    extends Execution {
        SingleEntityExecution() {
        }

        Object execute(Query query) {
            List<?> result = this.readCollection(query);
            return result.isEmpty() ? null : result.get(0);
        }
    }

    class PagedExecution
    extends Execution {
        private final Pageable pageable;
        private final MongoQueryCreator creator;

        public PagedExecution(MongoQueryCreator creator, Pageable pageable) {
            Assert.notNull((Object)((Object)creator));
            Assert.notNull((Object)pageable);
            this.creator = creator;
            this.pageable = pageable;
        }

        Object execute(Query query) {
            Query countQuery = (Query)this.creator.createQuery();
            String collectionName = QueryUtils.getCollectionName(MongoQuery.this.method.getDomainClass());
            int count = this.getCollectionCursor(collectionName, countQuery.getQueryObject()).count();
            List result = MongoQuery.this.template.find(collectionName, QueryUtils.applyPagination(query, this.pageable), MongoQuery.this.method.getDomainClass());
            return new PageImpl(result, this.pageable, (long)count);
        }

        private DBCursor getCollectionCursor(String collectionName, final DBObject query) {
            return MongoQuery.this.template.execute(collectionName, new CollectionCallback<DBCursor>(){

                @Override
                public DBCursor doInCollection(DBCollection collection) {
                    return collection.find(query);
                }
            });
        }
    }

    class CollectionExecution
    extends Execution {
        CollectionExecution() {
        }

        public Object execute(Query query) {
            return this.readCollection(query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Execution {
        private Execution() {
        }

        abstract Object execute(Query var1);

        protected List<?> readCollection(Query query) {
            String collectionName = QueryUtils.getCollectionName(MongoQuery.this.method.getDomainClass());
            return MongoQuery.this.template.find(collectionName, query, MongoQuery.this.method.getDomainClass());
        }
    }
}

