/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.MongoConverter;
import org.springframework.data.document.mongodb.query.Criteria;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.SimpleParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoQueryCreator
extends AbstractQueryCreator<Query, Criteria> {
    private static final Log LOG = LogFactory.getLog(MongoQueryCreator.class);
    private final MongoConverter converter;

    public MongoQueryCreator(PartTree tree, SimpleParameterAccessor accessor, MongoConverter converter) {
        super(tree, accessor);
        this.converter = converter;
    }

    protected Criteria create(Part part, SimpleParameterAccessor.BindableParameterIterator iterator) {
        return this.from(part.getType(), Criteria.where(part.getProperty().toDotPath()), iterator);
    }

    protected Criteria and(Part part, Criteria base, SimpleParameterAccessor.BindableParameterIterator iterator) {
        return this.from(part.getType(), Criteria.where(part.getProperty().toDotPath()), iterator);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        base.or(Collections.singletonList(new Query(criteria)));
        return base;
    }

    protected Query complete(Criteria criteria, Sort sort) {
        Query query = new Query(criteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created query " + query.getQueryObject()));
        }
        return query;
    }

    private Criteria from(Part.Type type, Criteria criteria, SimpleParameterAccessor.BindableParameterIterator parameters) {
        switch (type) {
            case GREATER_THAN: {
                return criteria.gt(this.getConvertedParameter(parameters));
            }
            case LESS_THAN: {
                return criteria.lt(this.getConvertedParameter(parameters));
            }
            case BETWEEN: {
                return criteria.gt(this.getConvertedParameter(parameters)).lt(this.getConvertedParameter(parameters));
            }
            case IS_NOT_NULL: {
                return criteria.not().is(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case LIKE: {
                String value = parameters.next().toString();
                return criteria.is(this.toLikeRegex(value));
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(this.getConvertedParameter(parameters));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.not().is(this.getConvertedParameter(parameters));
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private Object getConvertedParameter(SimpleParameterAccessor.BindableParameterIterator parameters) {
        BasicDBObject result = new BasicDBObject();
        this.converter.write(new ValueHolder(parameters.next()), (DBObject)result);
        return result.get("value");
    }

    private Pattern toLikeRegex(String source) {
        String regex = source.replaceAll("\\*", ".*");
        return Pattern.compile(regex);
    }

    private static class ValueHolder {
        private Object value;

        public ValueHolder(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

