/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.document.mongodb.MongoPropertyDescriptors;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.repository.MongoQuery;
import org.springframework.data.document.mongodb.repository.MongoRepository;
import org.springframework.data.document.mongodb.repository.SimpleMongoRepository;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.support.RepositoryFactorySupport;
import org.springframework.data.repository.support.RepositorySupport;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryFactoryBean
extends RepositoryFactoryBeanSupport<MongoRepository<?, ?>> {
    private MongoTemplate template;

    public void setTemplate(MongoTemplate template) {
        this.template = template;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new MongoRepositoryFactory(this.template);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.template, (String)"MongoTemplate must not be null!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoRepositoryFactory
    extends RepositoryFactorySupport {
        private final MongoTemplate template;

        public MongoRepositoryFactory(MongoTemplate template) {
            this.template = template;
        }

        protected <T, ID extends Serializable> RepositorySupport<T, ID> getTargetRepository(Class<T> domainClass, Class<?> repositoryInterface) {
            return new SimpleMongoRepository(domainClass, this.template);
        }

        protected Class<? extends RepositorySupport> getRepositoryClass(Class<?> repositoryInterface) {
            return SimpleMongoRepository.class;
        }

        protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
            return new MongoQueryLookupStrategy();
        }

        protected void validate(Class<? extends Repository<?, ?>> repositoryInterface, Object customImplementation) {
            Class idClass = ClassUtils.getIdClass(repositoryInterface);
            if (!MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES.contains(idClass)) {
                throw new IllegalArgumentException(String.format("Unsupported id class! Only %s are supported!", StringUtils.collectionToCommaDelimitedString(MongoPropertyDescriptors.MongoPropertyDescriptor.SUPPORTED_ID_CLASSES)));
            }
            super.validate(repositoryInterface, customImplementation);
        }

        private class MongoQueryLookupStrategy
        implements QueryLookupStrategy {
            private MongoQueryLookupStrategy() {
            }

            public RepositoryQuery resolveQuery(Method method) {
                return new MongoQuery(new QueryMethod(method), MongoRepositoryFactory.this.template);
            }
        }
    }
}

