/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.document.mongodb.MongoConverter;
import org.springframework.data.document.mongodb.MongoTemplate;
import org.springframework.data.document.mongodb.query.Criteria;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.repository.MongoEntityInformation;
import org.springframework.data.document.mongodb.repository.QueryUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.support.IsNewAware;
import org.springframework.data.repository.support.RepositorySupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMongoRepository<T, ID extends Serializable>
extends RepositorySupport<T, ID>
implements PagingAndSortingRepository<T, ID> {
    private final MongoTemplate template;
    private MongoEntityInformation entityInformation;

    public SimpleMongoRepository(Class<T> domainClass, MongoTemplate template) {
        super(domainClass);
        Assert.notNull((Object)template);
        this.template = template;
    }

    public T save(T entity) {
        this.template.save(QueryUtils.getCollectionName(this.getDomainClass()), entity);
        return entity;
    }

    public List<T> save(Iterable<? extends T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        for (T entity : entities) {
            this.save(entity);
            result.add(entity);
        }
        return result;
    }

    public T findById(ID id) {
        MongoConverter converter = this.template.getConverter();
        ObjectId objectId = converter.convertObjectId(id);
        return this.template.findOne(QueryUtils.getCollectionName(this.getDomainClass()), new Query(Criteria.where("_id").is(objectId)), this.getDomainClass());
    }

    public boolean exists(ID id) {
        return this.findById(id) == null;
    }

    public List<T> findAll() {
        return this.template.getCollection(QueryUtils.getCollectionName(this.getDomainClass()), this.getDomainClass());
    }

    public Long count() {
        return this.template.getCollection(QueryUtils.getCollectionName(this.getDomainClass())).count();
    }

    public void delete(T entity) {
        Query query = new Query(Criteria.where(this.entityInformation.getFieldName()).is(this.entityInformation.getId(entity)));
        this.template.remove(QueryUtils.getCollectionName(this.getDomainClass()), query);
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    public void deleteAll() {
        this.template.dropCollection(QueryUtils.getCollectionName(this.getDomainClass()));
    }

    public Page<T> findAll(Pageable pageable) {
        Long count = this.count();
        Query spec = new Query();
        List list = this.template.find(QueryUtils.getCollectionName(this.getDomainClass()), QueryUtils.applyPagination(spec, pageable), this.getDomainClass());
        return new PageImpl(list, pageable, count.longValue());
    }

    public List<T> findAll(Sort sort) {
        Query query = QueryUtils.applySorting(new Query(), sort);
        return this.template.find(QueryUtils.getCollectionName(this.getDomainClass()), query, this.getDomainClass());
    }

    protected IsNewAware createIsNewStrategy(Class<?> domainClass) {
        if (this.entityInformation == null) {
            this.entityInformation = new MongoEntityInformation(domainClass);
        }
        return this.entityInformation;
    }
}

