/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.MongoAdminOperations;
import org.springframework.data.document.mongodb.MongoDbUtils;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Mongo Admin Operations")
public class MongoAdmin
implements MongoAdminOperations {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Mongo mongo;
    private String username;
    private String password;

    public MongoAdmin(Mongo mongo) {
        this.mongo = mongo;
    }

    @ManagedOperation
    public void dropDatabase(String databaseName) {
        this.getDB(databaseName).dropDatabase();
    }

    @ManagedOperation
    public void createDatabase(String databaseName) {
        this.getDB(databaseName);
    }

    @ManagedOperation
    public String getDatabaseStats(String databaseName) {
        return this.getDB(databaseName).getStats().toString();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    DB getDB(String databaseName) {
        return MongoDbUtils.getDB(this.mongo, databaseName, this.username, this.password == null ? null : this.password.toCharArray());
    }
}

