/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.document.mongodb.CannotGetMongoDbConnectionException;
import org.springframework.data.document.mongodb.DbHolder;
import org.springframework.data.document.mongodb.MongoSynchronization;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class MongoDbUtils {
    private static final Log LOGGER = LogFactory.getLog(MongoDbUtils.class);

    private MongoDbUtils() {
    }

    public static DB getDB(Mongo mongo, String databaseName) {
        return MongoDbUtils.doGetDB(mongo, databaseName, null, null, true);
    }

    public static DB getDB(Mongo mongo, String databaseName, String username, char[] password) {
        return MongoDbUtils.doGetDB(mongo, databaseName, username, password, true);
    }

    public static DB doGetDB(Mongo mongo, String databaseName, String username, char[] password, boolean allowCreate) {
        boolean credentialsGiven;
        DB db;
        Assert.notNull((Object)mongo, (String)"No Mongo instance specified");
        DbHolder dbHolder = (DbHolder)((Object)TransactionSynchronizationManager.getResource((Object)mongo));
        if (dbHolder != null && !dbHolder.isEmpty()) {
            db = null;
            if (TransactionSynchronizationManager.isSynchronizationActive() && dbHolder.doesNotHoldNonDefaultDB() && (db = dbHolder.getDB()) != null && !dbHolder.isSynchronizedWithTransaction()) {
                LOGGER.debug((Object)"Registering Spring transaction synchronization for existing Mongo DB");
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new MongoSynchronization((ResourceHolder)dbHolder, mongo));
                dbHolder.setSynchronizedWithTransaction(true);
            }
            if (db != null) {
                return db;
            }
        }
        LOGGER.trace((Object)("Getting Mongo Database name=[" + databaseName + "]"));
        db = mongo.getDB(databaseName);
        boolean bl = credentialsGiven = username != null && password != null;
        if (credentialsGiven && !db.isAuthenticated() && !db.authenticate(username, password)) {
            throw new CannotGetMongoDbConnectionException("Failed to authenticate to database [" + databaseName + "], username = [" + username + "], password = [" + new String(password) + "]", databaseName, username, password);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            LOGGER.debug((Object)"Registering Spring transaction synchronization for new Hibernate Session");
            DbHolder holderToUse = dbHolder;
            if (holderToUse == null) {
                holderToUse = new DbHolder(db);
            } else {
                holderToUse.addDB(db);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new MongoSynchronization((ResourceHolder)holderToUse, mongo));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != dbHolder) {
                TransactionSynchronizationManager.bindResource((Object)mongo, (Object)((Object)holderToUse));
            }
        }
        if (!allowCreate && !MongoDbUtils.isDBTransactional(db, mongo)) {
            throw new IllegalStateException("No Mongo DB bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return db;
    }

    public static boolean isDBTransactional(DB db, Mongo mongo) {
        if (mongo == null) {
            return false;
        }
        DbHolder dbHolder = (DbHolder)((Object)TransactionSynchronizationManager.getResource((Object)mongo));
        return dbHolder != null && dbHolder.containsDB(db);
    }

    public static void closeDB(DB db) {
        if (db != null) {
            LOGGER.debug((Object)"Closing Mongo DB object");
            try {
                db.requestDone();
            }
            catch (Throwable ex) {
                LOGGER.debug((Object)"Unexpected exception on closing Mongo DB object", ex);
            }
        }
    }
}

