/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.document.mongodb.CannotGetMongoDbConnectionException;
import org.springframework.data.document.mongodb.MongoExceptionTranslator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoFactoryBean
implements FactoryBean<Mongo>,
InitializingBean,
PersistenceExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Mongo mongo;
    private MongoOptions mongoOptions;
    private String host;
    private Integer port;
    private List<ServerAddress> replicaSetSeeds;
    private List<ServerAddress> replicaPair;
    private PersistenceExceptionTranslator exceptionTranslator = new MongoExceptionTranslator();

    public void setMongoOptions(MongoOptions mongoOptions) {
        this.mongoOptions = mongoOptions;
    }

    public void setReplicaSetSeeds(List<ServerAddress> replicaSetSeeds) {
        this.replicaSetSeeds = replicaSetSeeds;
    }

    public void setReplicaPair(List<ServerAddress> replicaPair) {
        this.replicaPair = replicaPair;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    public Mongo getObject() throws Exception {
        Assert.notNull((Object)this.mongo, (String)"Mongo must not be null");
        return this.mongo;
    }

    public Class<? extends Mongo> getObjectType() {
        return Mongo.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongo == null) {
            if (this.host == null) {
                this.logger.warn((Object)"Property host not specified. Using default configuration");
                this.mongo = new Mongo();
            } else {
                ServerAddress defaultOptions = new ServerAddress();
                if (this.mongoOptions == null) {
                    this.mongoOptions = new MongoOptions();
                }
                if (this.replicaPair != null) {
                    if (this.replicaPair.size() < 2) {
                        throw new CannotGetMongoDbConnectionException("A replica pair must have two server entries");
                    }
                    this.mongo = new Mongo(this.replicaPair.get(0), this.replicaPair.get(1), this.mongoOptions);
                } else if (this.replicaSetSeeds != null) {
                    this.mongo = new Mongo(this.replicaSetSeeds, this.mongoOptions);
                } else {
                    String mongoHost = this.host != null ? this.host : defaultOptions.getHost();
                    this.mongo = this.port != null ? new Mongo(new ServerAddress(mongoHost, this.port.intValue()), this.mongoOptions) : new Mongo(mongoHost, this.mongoOptions);
                }
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }
}

