/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoPropertyDescriptors
implements Iterable<MongoPropertyDescriptor> {
    private final Collection<MongoPropertyDescriptor> descriptors;
    private final MongoPropertyDescriptor idDescriptor;

    public MongoPropertyDescriptors(Class<?> type) {
        Assert.notNull(type);
        HashSet<MongoPropertyDescriptor> descriptors = new HashSet<MongoPropertyDescriptor>();
        MongoPropertyDescriptor idDesciptor = null;
        for (PropertyDescriptor candidates : BeanUtils.getPropertyDescriptors(type)) {
            MongoPropertyDescriptor descriptor = new MongoPropertyDescriptor(candidates, type);
            descriptors.add(descriptor);
            if (!descriptor.isIdProperty()) continue;
            idDesciptor = descriptor;
        }
        this.descriptors = Collections.unmodifiableSet(descriptors);
        this.idDescriptor = idDesciptor;
    }

    public MongoPropertyDescriptor getIdDescriptor() {
        return this.idDescriptor;
    }

    @Override
    public Iterator<MongoPropertyDescriptor> iterator() {
        return this.descriptors.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MongoPropertyDescriptor {
        public static Collection<Class<?>> SUPPORTED_ID_CLASSES;
        private static final String ID_PROPERTY = "id";
        static final String ID_KEY = "_id";
        private final PropertyDescriptor delegate;
        private final Class<?> owningType;

        public MongoPropertyDescriptor(PropertyDescriptor descriptor, Class<?> owningType) {
            Assert.notNull((Object)descriptor);
            this.delegate = descriptor;
            this.owningType = owningType;
        }

        public boolean isIdProperty() {
            return ID_PROPERTY.equals(this.delegate.getName()) || ID_KEY.equals(this.delegate.getName());
        }

        public boolean isOfIdType() {
            return SUPPORTED_ID_CLASSES.contains(this.delegate.getPropertyType());
        }

        public String getKeyToMap() {
            return this.isIdProperty() ? ID_KEY : this.delegate.getName();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isMappable() {
            boolean isNotClassAttribute = !this.delegate.getName().equals("class");
            boolean hasGetter = this.delegate.getReadMethod() != null;
            boolean hasField = ReflectionUtils.findField(this.owningType, (String)this.delegate.getName()) != null;
            return isNotClassAttribute && hasGetter && hasField;
        }

        public Class<?> getPropertyType() {
            return this.delegate.getPropertyType();
        }

        public Type getTypeToSet() {
            Method method = this.delegate.getWriteMethod();
            return method == null ? this.delegate.getReadMethod().getGenericReturnType() : method.getGenericParameterTypes()[0];
        }

        public boolean isMap() {
            return Map.class.isAssignableFrom(this.getPropertyType());
        }

        public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.getPropertyType());
        }

        public boolean isEnum() {
            return Enum.class.isAssignableFrom(this.getPropertyType());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            MongoPropertyDescriptor that = (MongoPropertyDescriptor)obj;
            return that.delegate.equals(this.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        static {
            HashSet<Class<BigInteger>> classes = new HashSet<Class<BigInteger>>();
            classes.add(ObjectId.class);
            classes.add(String.class);
            classes.add(BigInteger.class);
            SUPPORTED_ID_CLASSES = Collections.unmodifiableCollection(classes);
        }
    }
}

