/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.document.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.document.mongodb.CollectionCallback;
import org.springframework.data.document.mongodb.CollectionOptions;
import org.springframework.data.document.mongodb.CursorPreparer;
import org.springframework.data.document.mongodb.DbCallback;
import org.springframework.data.document.mongodb.MongoDbFactory;
import org.springframework.data.document.mongodb.MongoExceptionTranslator;
import org.springframework.data.document.mongodb.MongoOperations;
import org.springframework.data.document.mongodb.MongoReader;
import org.springframework.data.document.mongodb.MongoWriter;
import org.springframework.data.document.mongodb.SimpleMongoDbFactory;
import org.springframework.data.document.mongodb.WriteResultChecking;
import org.springframework.data.document.mongodb.convert.MappingMongoConverter;
import org.springframework.data.document.mongodb.convert.MongoConverter;
import org.springframework.data.document.mongodb.index.IndexDefinition;
import org.springframework.data.document.mongodb.mapping.MongoMappingContext;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntity;
import org.springframework.data.document.mongodb.mapping.MongoPersistentEntityIndexCreator;
import org.springframework.data.document.mongodb.mapping.MongoPersistentProperty;
import org.springframework.data.document.mongodb.mapping.event.AfterConvertEvent;
import org.springframework.data.document.mongodb.mapping.event.AfterLoadEvent;
import org.springframework.data.document.mongodb.mapping.event.AfterSaveEvent;
import org.springframework.data.document.mongodb.mapping.event.BeforeConvertEvent;
import org.springframework.data.document.mongodb.mapping.event.BeforeSaveEvent;
import org.springframework.data.document.mongodb.mapping.event.MongoMappingEvent;
import org.springframework.data.document.mongodb.mapping.event.MongoMappingEventPublisher;
import org.springframework.data.document.mongodb.query.Criteria;
import org.springframework.data.document.mongodb.query.Query;
import org.springframework.data.document.mongodb.query.QueryMapper;
import org.springframework.data.document.mongodb.query.Update;
import org.springframework.data.mapping.BeanWrapper;
import org.springframework.data.mapping.model.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.PersistentProperty;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoTemplate
implements MongoOperations,
ApplicationContextAware {
    private static final Log LOGGER = LogFactory.getLog(MongoTemplate.class);
    private static final String ID = "_id";
    private static final List<String> ITERABLE_CLASSES = new ArrayList<String>(){
        {
            this.add(List.class.getName());
            this.add(Collection.class.getName());
            this.add(Iterator.class.getName());
        }
    };
    private WriteConcern writeConcern = null;
    private WriteResultChecking writeResultChecking = WriteResultChecking.NONE;
    private boolean slaveOk = false;
    private MongoConverter mongoConverter;
    private MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private MongoDbFactory mongoDbFactory;
    private MongoExceptionTranslator exceptionTranslator = new MongoExceptionTranslator();
    private QueryMapper mapper;
    private ApplicationEventPublisher eventPublisher;
    private MongoPersistentEntityIndexCreator indexCreator;

    public MongoTemplate(Mongo mongo, String databaseName) {
        this(new SimpleMongoDbFactory(mongo, databaseName), null, null, null);
    }

    public MongoTemplate(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        this(new SimpleMongoDbFactory(mongo, databaseName, userCredentials));
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null, null, null);
    }

    public MongoTemplate(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter) {
        this(mongoDbFactory, mongoConverter, null, null);
    }

    MongoTemplate(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter, WriteConcern writeConcern, WriteResultChecking writeResultChecking) {
        Assert.notNull((Object)mongoDbFactory);
        this.mongoDbFactory = mongoDbFactory;
        this.mongoConverter = null == mongoConverter ? this.getDefaultMongoConverter() : mongoConverter;
        this.mappingContext = this.mongoConverter.getMappingContext();
        if (null != this.mappingContext && this.mappingContext instanceof MongoMappingContext) {
            this.indexCreator = new MongoPersistentEntityIndexCreator((MongoMappingContext)this.mappingContext, mongoDbFactory);
            this.eventPublisher = new MongoMappingEventPublisher(this.indexCreator);
            if (this.mappingContext instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
            }
        }
        this.writeConcern = writeConcern;
        this.mapper = new QueryMapper(this.mongoConverter);
        if (writeResultChecking != null) {
            this.writeResultChecking = writeResultChecking;
        }
    }

    private final MongoConverter getDefaultMongoConverter() {
        MappingMongoConverter converter = new MappingMongoConverter(this.mongoDbFactory, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        converter.afterPropertiesSet();
        return converter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] beans = applicationContext.getBeanNamesForType(MongoPersistentEntityIndexCreator.class);
        if ((null == beans || beans.length == 0) && applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this.indexCreator);
        }
        this.eventPublisher = applicationContext;
        if (this.mappingContext instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)this.mappingContext).setApplicationEventPublisher(this.eventPublisher);
        }
    }

    public MongoConverter getConverter() {
        return this.mongoConverter;
    }

    public MongoDbFactory getDbFactory() {
        return this.mongoDbFactory;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public String getCollectionName(Class<?> entityClass) {
        return this.determineCollectionName(entityClass);
    }

    @Override
    public CommandResult executeCommand(String jsonCommand) {
        return this.executeCommand((DBObject)JSON.parse((String)jsonCommand));
    }

    @Override
    public CommandResult executeCommand(final DBObject command) {
        CommandResult result = this.execute(new DbCallback<CommandResult>(){

            @Override
            public CommandResult doInDB(DB db) throws MongoException, DataAccessException {
                return db.command(command);
            }
        });
        String error = result.getErrorMessage();
        if (error != null) {
            LOGGER.warn((Object)("Command execution of " + command.toString() + " failed: " + error));
        }
        return result;
    }

    @Override
    public <T> T execute(DbCallback<T> action) {
        Assert.notNull(action);
        try {
            DB db = this.getDb();
            return action.doInDB(db);
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    @Override
    public <T> T execute(Class<?> entityClass, CollectionCallback<T> callback) {
        return this.execute(this.determineCollectionName(entityClass), callback);
    }

    @Override
    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Assert.notNull(callback);
        try {
            DBCollection collection = this.getAndPrepareCollection(this.getDb(), collectionName);
            return callback.doInCollection(collection);
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    @Override
    public <T> T executeInSession(final DbCallback<T> action) {
        return this.execute(new DbCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInDB(DB db) throws MongoException, DataAccessException {
                try {
                    db.requestStart();
                    Object t = action.doInDB(db);
                    return t;
                }
                finally {
                    db.requestDone();
                }
            }
        });
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass) {
        return this.createCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public <T> DBCollection createCollection(Class<T> entityClass, CollectionOptions collectionOptions) {
        return this.createCollection(this.determineCollectionName(entityClass), collectionOptions);
    }

    @Override
    public DBCollection createCollection(String collectionName) {
        return this.doCreateCollection(collectionName, (DBObject)new BasicDBObject());
    }

    @Override
    public DBCollection createCollection(String collectionName, CollectionOptions collectionOptions) {
        return this.doCreateCollection(collectionName, this.convertToDbObject(collectionOptions));
    }

    @Override
    public DBCollection getCollection(final String collectionName) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollection(collectionName);
            }
        });
    }

    @Override
    public <T> boolean collectionExists(Class<T> entityClass) {
        return this.collectionExists(this.determineCollectionName(entityClass));
    }

    @Override
    public boolean collectionExists(final String collectionName) {
        return this.execute(new DbCallback<Boolean>(){

            @Override
            public Boolean doInDB(DB db) throws MongoException, DataAccessException {
                return db.collectionExists(collectionName);
            }
        });
    }

    @Override
    public <T> void dropCollection(Class<T> entityClass) {
        this.dropCollection(this.determineCollectionName(entityClass));
    }

    @Override
    public void dropCollection(String collectionName) {
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.drop();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Dropped collection [" + collection.getFullName() + "]"));
                }
                return null;
            }
        });
    }

    @Override
    public void ensureIndex(IndexDefinition indexDefinition, Class<?> entityClass) {
        this.ensureIndex(indexDefinition, this.determineCollectionName(entityClass));
    }

    @Override
    public void ensureIndex(final IndexDefinition indexDefinition, String collectionName) {
        this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject indexOptions = indexDefinition.getIndexOptions();
                if (indexOptions != null) {
                    collection.ensureIndex(indexDefinition.getIndexKeys(), indexOptions);
                } else {
                    collection.ensureIndex(indexDefinition.getIndexKeys());
                }
                return null;
            }
        });
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass) {
        return this.findOne(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindOne(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass);
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(final Query query, Class<T> entityClass, String collectionName) {
        CursorPreparer cursorPreparer = null;
        if (query.getSkip() > 0 || query.getLimit() > 0 || query.getSortObject() != null) {
            cursorPreparer = new CursorPreparer(){

                public DBCursor prepare(DBCursor cursor) {
                    DBCursor cursorToUse = cursor;
                    try {
                        if (query.getSkip() > 0) {
                            cursorToUse = cursorToUse.skip(query.getSkip());
                        }
                        if (query.getLimit() > 0) {
                            cursorToUse = cursorToUse.limit(query.getLimit());
                        }
                        if (query.getSortObject() != null) {
                            cursorToUse = cursorToUse.sort(query.getSortObject());
                        }
                    }
                    catch (RuntimeException e) {
                        throw MongoTemplate.this.potentiallyConvertRuntimeException(e);
                    }
                    return cursorToUse;
                }
            };
        }
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, cursorPreparer);
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, CursorPreparer preparer, String collectionName) {
        return this.doFind(collectionName, query.getQueryObject(), query.getFieldsObject(), entityClass, preparer);
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.findById(id, entityClass, persistentEntity.getCollection());
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, String collectionName) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
        String idKey = idProperty == null ? ID : idProperty.getName();
        return this.doFindOne(collectionName, (DBObject)new BasicDBObject(idKey, id), null, entityClass);
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass) {
        return this.findAndRemove(query, entityClass, this.determineCollectionName(entityClass));
    }

    @Override
    public <T> T findAndRemove(Query query, Class<T> entityClass, String collectionName) {
        return this.doFindAndRemove(collectionName, query.getQueryObject(), query.getFieldsObject(), query.getSortObject(), entityClass);
    }

    @Override
    public void insert(Object objectToSave) {
        this.ensureNotIterable(objectToSave);
        this.insert(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void insert(Object objectToSave, String collectionName) {
        this.ensureNotIterable(objectToSave);
        this.doInsert(collectionName, objectToSave, this.mongoConverter);
    }

    protected void ensureNotIterable(Object o) {
        if (null != o && (o.getClass().isArray() || ITERABLE_CLASSES.contains(o.getClass().getName()))) {
            throw new IllegalArgumentException("Cannot use a collection here.");
        }
    }

    protected void prepareCollection(DBCollection collection) {
        if (this.slaveOk) {
            collection.slaveOk();
        }
    }

    protected WriteConcern prepareWriteConcern(WriteConcern writeConcern) {
        return writeConcern;
    }

    protected <T> void doInsert(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BasicDBObject dbDoc = new BasicDBObject();
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave));
        writer.write(objectToSave, (DBObject)dbDoc);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, (DBObject)dbDoc));
        Object id = this.insertDBObject(collectionName, (DBObject)dbDoc);
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, (DBObject)dbDoc));
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        this.doInsertBatch(this.determineCollectionName(entityClass), batchToSave, this.mongoConverter);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String collectionName) {
        this.doInsertBatch(collectionName, batchToSave, this.mongoConverter);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        this.doInsertAll(objectsToSave, this.mongoConverter);
    }

    protected <T> void doInsertAll(Collection<? extends T> listToSave, MongoWriter<T> writer) {
        HashMap<String, ArrayList<T>> objs = new HashMap<String, ArrayList<T>>();
        for (T t : listToSave) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(t.getClass());
            if (entity == null) {
                throw new InvalidDataAccessApiUsageException("No Persitent Entity information found for the class " + t.getClass().getName());
            }
            String collection = entity.getCollection();
            ArrayList<T> objList = (ArrayList<T>)objs.get(collection);
            if (null == objList) {
                objList = new ArrayList<T>();
                objs.put(collection, objList);
            }
            objList.add(t);
        }
        for (Map.Entry entry : objs.entrySet()) {
            this.doInsertBatch((String)entry.getKey(), (Collection)entry.getValue(), this.mongoConverter);
        }
    }

    protected <T> void doInsertBatch(String collectionName, Collection<? extends T> batchToSave, MongoWriter<T> writer) {
        Assert.notNull(writer);
        ArrayList<DBObject> dbObjectList = new ArrayList<DBObject>();
        for (T o : batchToSave) {
            BasicDBObject dbDoc = new BasicDBObject();
            this.maybeEmitEvent(new BeforeConvertEvent<T>(o));
            writer.write(o, (DBObject)dbDoc);
            this.maybeEmitEvent(new BeforeSaveEvent<T>(o, (DBObject)dbDoc));
            dbObjectList.add((DBObject)dbDoc);
        }
        List<ObjectId> ids = this.insertDBObjectList(collectionName, dbObjectList);
        int i = 0;
        for (T obj : batchToSave) {
            if (i < ids.size()) {
                this.populateIdIfNecessary(obj, ids.get(i));
                this.maybeEmitEvent(new AfterSaveEvent<T>(obj, (DBObject)dbObjectList.get(i)));
            }
            ++i;
        }
    }

    @Override
    public void save(Object objectToSave) {
        this.save(objectToSave, this.determineEntityCollectionName(objectToSave));
    }

    @Override
    public void save(Object objectToSave, String collectionName) {
        this.doSave(collectionName, objectToSave, this.mongoConverter);
    }

    protected <T> void doSave(String collectionName, T objectToSave, MongoWriter<T> writer) {
        BasicDBObject dbDoc = new BasicDBObject();
        this.maybeEmitEvent(new BeforeConvertEvent<T>(objectToSave));
        writer.write(objectToSave, (DBObject)dbDoc);
        this.maybeEmitEvent(new BeforeSaveEvent<T>(objectToSave, (DBObject)dbDoc));
        Object id = this.saveDBObject(collectionName, (DBObject)dbDoc);
        this.populateIdIfNecessary(objectToSave, id);
        this.maybeEmitEvent(new AfterSaveEvent<T>(objectToSave, (DBObject)dbDoc));
    }

    protected Object insertDBObject(String collectionName, final DBObject dbDoc) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("insert DBObject containing fields: " + dbDoc.keySet() + " in collection: " + collectionName));
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(MongoTemplate.this.writeConcern);
                if (writeConcernToUse == null) {
                    collection.insert(new DBObject[]{dbDoc});
                } else {
                    collection.insert(dbDoc, writeConcernToUse);
                }
                return dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    protected List<ObjectId> insertDBObjectList(String collectionName, final List<DBObject> dbDocList) {
        if (dbDocList.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("insert list of DBObjects containing " + dbDocList.size() + " items"));
        }
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(MongoTemplate.this.writeConcern);
                if (writeConcernToUse == null) {
                    collection.insert(dbDocList);
                } else {
                    collection.insert(dbDocList.toArray((DBObject[])new BasicDBObject[dbDocList.size()]), writeConcernToUse);
                }
                return null;
            }
        });
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (DBObject dbo : dbDocList) {
            Object id = dbo.get(ID);
            if (id instanceof ObjectId) {
                ids.add((ObjectId)id);
                continue;
            }
            ids.add(null);
        }
        return ids;
    }

    protected Object saveDBObject(String collectionName, final DBObject dbDoc) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("save DBObject containing fields: " + dbDoc.keySet()));
        }
        return this.execute(collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(MongoTemplate.this.writeConcern);
                if (writeConcernToUse == null) {
                    collection.save(dbDoc);
                } else {
                    collection.save(dbDoc, writeConcernToUse);
                }
                return dbDoc.get(MongoTemplate.ID);
            }
        });
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, false);
    }

    @Override
    public WriteResult updateFirst(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, false);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, Class<?> entityClass) {
        return this.doUpdate(this.determineCollectionName(entityClass), query, update, entityClass, false, true);
    }

    @Override
    public WriteResult updateMulti(Query query, Update update, String collectionName) {
        return this.doUpdate(collectionName, query, update, null, false, true);
    }

    protected WriteResult doUpdate(final String collectionName, final Query query, final Update update, final Class<?> entityClass, final boolean upsert, final boolean multi) {
        return this.execute(collectionName, new CollectionCallback<WriteResult>(){

            @Override
            public WriteResult doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                WriteConcern writeConcernToUse;
                DBObject queryObj = query.getQueryObject();
                DBObject updateObj = update.getUpdateObject();
                String idProperty = "id";
                if (null != entityClass) {
                    idProperty = ((MongoPersistentProperty)MongoTemplate.this.getPersistentEntity(entityClass).getIdProperty()).getName();
                }
                for (String key : queryObj.keySet()) {
                    if (idProperty.equals(key)) {
                        queryObj.put(MongoTemplate.ID, MongoTemplate.this.mongoConverter.maybeConvertObject(queryObj.get(key)));
                        queryObj.removeField(key);
                        continue;
                    }
                    queryObj.put(key, MongoTemplate.this.mongoConverter.maybeConvertObject(queryObj.get(key)));
                }
                for (String key : updateObj.keySet()) {
                    updateObj.put(key, MongoTemplate.this.mongoConverter.maybeConvertObject(updateObj.get(key)));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("calling update using query: " + queryObj + " and update: " + updateObj + " in collection: " + collectionName));
                }
                WriteResult wr = (writeConcernToUse = MongoTemplate.this.prepareWriteConcern(MongoTemplate.this.writeConcern)) == null ? (multi ? collection.updateMulti(queryObj, updateObj) : collection.update(queryObj, updateObj)) : collection.update(queryObj, updateObj, upsert, multi, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, queryObj, "update with '" + updateObj + "'");
                return wr;
            }
        });
    }

    @Override
    public void remove(Object object) {
        this.remove(new Query(Criteria.where(this.getIdPropertyName(object)).is(this.getIdValue(object))), object.getClass());
    }

    @Override
    public <T> void remove(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query);
        this.doRemove(this.determineCollectionName(entityClass), query, entityClass);
    }

    protected <T> void doRemove(String collectionName, Query query, Class<T> entityClass) {
        if (query == null) {
            throw new InvalidDataAccessApiUsageException("Query passed in to remove can't be null");
        }
        final DBObject queryObject = query.getQueryObject();
        final MongoPersistentEntity<?> entity = this.getPersistentEntity(entityClass);
        this.execute(collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject dboq = MongoTemplate.this.mapper.getMappedObject(queryObject, entity);
                WriteResult wr = null;
                WriteConcern writeConcernToUse = MongoTemplate.this.prepareWriteConcern(MongoTemplate.this.writeConcern);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("remove using query: " + queryObject + " in collection: " + collection.getName()));
                }
                wr = writeConcernToUse == null ? collection.remove(dboq) : collection.remove(dboq, writeConcernToUse);
                MongoTemplate.this.handleAnyWriteResultErrors(wr, dboq, "remove");
                return null;
            }
        });
    }

    @Override
    public void remove(Query query, String collectionName) {
        this.doRemove(collectionName, query, null);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), this.determineCollectionName(entityClass));
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, String collectionName) {
        return this.executeFindMultiInternal(new FindCallback(null), null, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), collectionName);
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.execute(new DbCallback<Set<String>>(){

            @Override
            public Set<String> doInDB(DB db) throws MongoException, DataAccessException {
                return db.getCollectionNames();
            }
        });
    }

    public DB getDb() {
        return this.mongoDbFactory.getDb();
    }

    protected <T> void maybeEmitEvent(MongoMappingEvent<T> event) {
        if (null != this.eventPublisher) {
            this.eventPublisher.publishEvent(event);
        }
    }

    protected DBCollection doCreateCollection(final String collectionName, final DBObject collectionOptions) {
        return this.execute(new DbCallback<DBCollection>(){

            @Override
            public DBCollection doInDB(DB db) throws MongoException, DataAccessException {
                DBCollection coll = db.createCollection(collectionName, collectionOptions);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Created collection [" + coll.getFullName() + "]"));
                }
                return coll;
            }
        });
    }

    protected <T> T doFindOne(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        DBObject mappedQuery = this.mapper.getMappedObject(query, entity);
        return (T)this.executeFindOneInternal(new FindOneCallback(mappedQuery, fields), new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass, CursorPreparer preparer) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("find using query: " + query + " fields: " + fields + " for class: " + entityClass + " in collection: " + collectionName));
        }
        return this.executeFindMultiInternal(new FindCallback(this.mapper.getMappedObject(query, entity), fields), preparer, new ReadDbObjectCallback<Object>(this.mongoConverter, entityClass), collectionName);
    }

    protected <T> List<T> doFind(String collectionName, DBObject query, DBObject fields, Class<T> entityClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("find using query: " + query + " fields: " + fields + " for class: " + entityClass + " in collection: " + collectionName));
        }
        MongoConverter readerToUse = this.mongoConverter;
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.executeFindMultiInternal(new FindCallback(this.mapper.getMappedObject(query, entity), fields), null, new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected DBObject convertToDbObject(CollectionOptions collectionOptions) {
        BasicDBObject dbo = new BasicDBObject();
        if (collectionOptions != null) {
            if (collectionOptions.getCapped() != null) {
                dbo.put("capped", (Object)collectionOptions.getCapped());
            }
            if (collectionOptions.getSize() != null) {
                dbo.put("size", (Object)collectionOptions.getSize());
            }
            if (collectionOptions.getMaxDocuments() != null) {
                dbo.put("max", (Object)collectionOptions.getMaxDocuments());
            }
        }
        return dbo;
    }

    protected <T> T doFindAndRemove(String collectionName, DBObject query, DBObject fields, DBObject sort, Class<T> entityClass) {
        MongoConverter readerToUse = this.mongoConverter;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("findAndRemove using query: " + query + " fields: " + fields + " sort: " + sort + " for class: " + entityClass + " in collection: " + collectionName));
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return (T)this.executeFindOneInternal(new FindAndRemoveCallback(this.mapper.getMappedObject(query, entity), fields, sort), new ReadDbObjectCallback<Object>(readerToUse, entityClass), collectionName);
    }

    protected Object getIdValue(Object object) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(object.getClass());
        MongoPersistentProperty idProp = (MongoPersistentProperty)entity.getIdProperty();
        if (idProp == null) {
            throw new MappingException("No id property found for object of type " + entity.getType().getName());
        }
        ConversionService service = this.mongoConverter.getConversionService();
        try {
            return BeanWrapper.create((Object)object, (ConversionService)service).getProperty((PersistentProperty)idProp, Object.class, true);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getIdPropertyName(Object object) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(object.getClass());
        MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
        return idProperty == null ? ID : idProperty.getName();
    }

    protected void populateIdIfNecessary(Object savedObject, Object id) {
        if (id == null) {
            return;
        }
        MongoPersistentProperty idProp = this.getIdPropertyFor(savedObject.getClass());
        if (idProp == null) {
            return;
        }
        try {
            BeanWrapper.create((Object)savedObject, (ConversionService)this.mongoConverter.getConversionService()).setProperty((PersistentProperty)idProp, id);
            return;
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    private DBCollection getAndPrepareCollection(DB db, String collectionName) {
        try {
            DBCollection collection = db.getCollection(collectionName);
            this.prepareCollection(collection);
            return collection;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private <T> T executeFindOneInternal(CollectionCallback<DBObject> collectionCallback, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            T result = objectCallback.doWith(collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName)));
            return result;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private <T> List<T> executeFindMultiInternal(CollectionCallback<DBCursor> collectionCallback, CursorPreparer preparer, DbObjectCallback<T> objectCallback, String collectionName) {
        try {
            DBCursor cursor = collectionCallback.doInCollection(this.getAndPrepareCollection(this.getDb(), collectionName));
            if (preparer != null) {
                cursor = preparer.prepare(cursor);
            }
            ArrayList<T> result = new ArrayList<T>();
            for (DBObject object : cursor) {
                result.add(objectCallback.doWith(object));
            }
            return result;
        }
        catch (RuntimeException e) {
            throw this.potentiallyConvertRuntimeException(e);
        }
    }

    private MongoPersistentEntity<?> getPersistentEntity(Class<?> type) {
        return type == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
    }

    private MongoPersistentProperty getIdPropertyFor(Class<?> type) {
        return (MongoPersistentProperty)((MongoPersistentEntity)this.mappingContext.getPersistentEntity(type)).getIdProperty();
    }

    private <T> String determineEntityCollectionName(T obj) {
        if (null != obj) {
            return this.determineCollectionName(obj.getClass());
        }
        return null;
    }

    private String determineCollectionName(Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined for " + entityClass);
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new InvalidDataAccessApiUsageException("No Persitent Entity information found for the class " + entityClass.getName());
        }
        return entity.getCollection();
    }

    private void handleAnyWriteResultErrors(WriteResult wr, DBObject query, String operation) {
        if (WriteResultChecking.NONE == this.writeResultChecking) {
            return;
        }
        String error = wr.getError();
        int n = wr.getN();
        if (error != null) {
            String message = "Execution of '" + operation + (query == null ? "" : "' using '" + query.toString() + "' query") + " failed: " + error;
            if (WriteResultChecking.EXCEPTION == this.writeResultChecking) {
                throw new DataIntegrityViolationException(message);
            }
            LOGGER.error((Object)message);
        } else if (n == 0) {
            String message = "Execution of '" + operation + (query == null ? "" : "' using '" + query.toString() + "' query") + " did not succeed: 0 documents updated";
            if (WriteResultChecking.EXCEPTION == this.writeResultChecking) {
                throw new DataIntegrityViolationException(message);
            }
            LOGGER.warn((Object)message);
        }
    }

    private RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    public void setWriteResultChecking(WriteResultChecking resultChecking) {
        this.writeResultChecking = resultChecking;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setSlaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReadDbObjectCallback<T>
    implements DbObjectCallback<T> {
        private final MongoReader<? super T> reader;
        private final Class<T> type;

        public ReadDbObjectCallback(MongoReader<? super T> reader, Class<T> type) {
            this.reader = reader;
            this.type = type;
        }

        @Override
        public T doWith(DBObject object) {
            T source;
            if (null != object) {
                MongoTemplate.this.maybeEmitEvent(new AfterLoadEvent<DBObject>(object));
            }
            if (null != (source = this.reader.read(this.type, object))) {
                MongoTemplate.this.maybeEmitEvent(new AfterConvertEvent<T>(object, source));
            }
            return source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DbObjectCallback<T> {
        public T doWith(DBObject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindAndRemoveCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;
        private final DBObject sort;

        public FindAndRemoveCallback(DBObject query, DBObject fields, DBObject sort) {
            this.query = query;
            this.fields = fields;
            this.sort = sort;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            return collection.findAndModify(this.query, this.fields, this.sort, true, null, false, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindCallback
    implements CollectionCallback<DBCursor> {
        private final DBObject query;
        private final DBObject fields;

        public FindCallback(DBObject query) {
            this(query, null);
        }

        public FindCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBCursor doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                return collection.find(this.query);
            }
            return collection.find(this.query, this.fields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindOneCallback
    implements CollectionCallback<DBObject> {
        private final DBObject query;
        private final DBObject fields;

        public FindOneCallback(DBObject query, DBObject fields) {
            this.query = query;
            this.fields = fields;
        }

        @Override
        public DBObject doInCollection(DBCollection collection) throws MongoException, DataAccessException {
            if (this.fields == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("findOne using query: " + this.query + " in db.collection: " + collection.getFullName()));
                }
                return collection.findOne(this.query);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("findOne using query: " + this.query + " fields: " + this.fields + " in db.collection: " + collection.getFullName()));
            }
            return collection.findOne(this.query, this.fields);
        }
    }
}

